/*
 * Decompiled with CFR 0.152.
 */
package functionplotter;

import functionplotter.App;
import functionplotter.AppConfig;
import functionplotter.AppIcon;
import functionplotter.CommentDialog;
import functionplotter.Expression;
import functionplotter.FileKind;
import functionplotter.Function;
import functionplotter.FunctionDialog;
import functionplotter.FunctionView;
import functionplotter.MainWindow;
import functionplotter.Operation;
import functionplotter.OperationDialog;
import functionplotter.PlotInterval;
import functionplotter.PlotPanel;
import functionplotter.Util;
import functionplotter.exception.AppException;
import functionplotter.exception.FileException;
import functionplotter.gui.SingleSelectionList;
import functionplotter.util.ColourUtilities;
import functionplotter.util.FileWritingMode;
import functionplotter.util.PngOutputFile;
import functionplotter.util.TextFile;
import functionplotter.xml.Comment;
import functionplotter.xml.XmlParseException;
import functionplotter.xml.XmlUtilities;
import functionplotter.xml.XmlValidationException;
import functionplotter.xml.XmlWriter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FunctionDocument
implements SingleSelectionList.Model<Function> {
    public static final int MAX_NUM_FUNCTIONS = 20;
    public static final String X_INTERVAL_KEY = "xInterval";
    public static final String Y_INTERVAL_KEY = "yInterval";
    public static final String FUNCTION_KEY = "function";
    private static final int VERSION = 0;
    private static final int MIN_SUPPORTED_VERSION = 0;
    private static final int MAX_SUPPORTED_VERSION = 0;
    private static final int MERGE_INTERVAL_EDITS_INTERVAL = 500;
    private static final char INTERVAL_PREFIX_CHAR = '@';
    private static final char COMMENT_PREFIX_CHAR = '#';
    private static final String XML_PREFIX = "<?functionplotter.xml";
    private static final String XML_VERSION_STR = "1.0";
    private static final String NAMESPACE_STR = "http://ns.blankaspect.org/funcPlotter-1";
    private static final String OLD_NAMESPACE_STR = "data:text/plain;charset=utf-8,FuncPlotter/functionList";
    private static final String UNTITLED_STR = "Untitled";
    private static final String LINE_STR = "Line ";
    private static final String PNG_STR = "png";
    private static final String READING_STR = "Reading";
    private static final String WRITING_STR = "Writing";
    private static final String COMMENT_STR = "Comment";
    private static final String ADD_FUNCTION_STR = "Add Function";
    private static final String EDIT_FUNCTION_STR = "Edit Function";
    private static final String DELETE_FUNCTION_STR = "Delete Function";
    private static final String DELETE_ALL_FUNCTIONS_STR = "Delete All Functions";
    private static final String CLEAR_EDIT_LIST_STR = "Do you want to clear all the undo/redo actions?";
    private static final String DELETE_MESSAGE_STR = "Do you want to delete the selected function?";
    private static final String DELETE_ALL_MESSAGE_STR = "Do you want to delete all the functions?";
    private static final String[] CC_OPTION_STRS = new String[]{"Clear", "Cancel"};
    private static final String[] DC_OPTION_STRS = new String[]{"Delete", "Cancel"};
    private File file;
    private FileKind fileKind = AppConfig.getInstance().getDefaultFileKind();
    private long timestamp;
    private int untitledIndex;
    private boolean executingCommand;
    private List<Function> functions = new ArrayList<Function>();
    private PlotInterval xInterval = new PlotInterval();
    private PlotInterval yInterval = new PlotInterval();
    private PlotInterval xStartInterval;
    private PlotInterval yStartInterval;
    private boolean commented;
    private Comment comment = new Comment();
    private EditList editList = new EditList();

    public FunctionDocument() {
    }

    public FunctionDocument(int n) {
        this();
        this.untitledIndex = n;
    }

    public static boolean canWriteImages() {
        return Util.indexOf(ImageIO.getWriterFormatNames(), PNG_STR) >= 0;
    }

    private static MainWindow getWindow() {
        return App.getInstance().getMainWindow();
    }

    @Override
    public int getNumElements() {
        return this.getNumFunctions();
    }

    @Override
    public Function getElement(int n) {
        return this.getFunction(n);
    }

    @Override
    public void setElement(int n, Function function) {
        this.functions.set(n, function);
    }

    @Override
    public void addElement(int n, Function function) {
        this.functions.add(n, function);
    }

    @Override
    public Function removeElement(int n) {
        return this.functions.remove(n);
    }

    public File getFile() {
        return this.file;
    }

    public FileEx getFileEx() {
        return new FileEx(this.file, this.fileKind);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public PlotInterval getXInterval() {
        return this.xInterval;
    }

    public PlotInterval getYInterval() {
        return this.yInterval;
    }

    public boolean hasComments() {
        return this.commented;
    }

    public boolean isExecutingCommand() {
        return this.executingCommand;
    }

    public boolean isChanged() {
        return this.editList.isChanged();
    }

    public int getNumFunctions() {
        return this.functions.size();
    }

    public Function getFunction(int n) {
        return this.functions.get(n);
    }

    public boolean hasFunctions() {
        return !this.functions.isEmpty();
    }

    public boolean isFull() {
        return this.functions.size() >= 20;
    }

    public String getTitleString(boolean bl) {
        String string;
        String string2 = this.file == null ? UNTITLED_STR + this.untitledIndex : (string = bl ? App.getPathname(this.file) : this.file.getName());
        if (this.isChanged()) {
            string = string + " *";
        }
        return string;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public void setIntervals(PlotInterval plotInterval, PlotInterval plotInterval2) {
        this.setXInterval(plotInterval);
        this.setYInterval(plotInterval2);
    }

    public void read(File file, List<String> list) throws AppException {
        list.clear();
        if (!file.exists()) {
            throw new FileException((AppException.Id)ErrorId.FILE_DOES_NOT_EXIST, file);
        }
        if (!file.isFile()) {
            throw new FileException((AppException.Id)ErrorId.NOT_A_FILE, file);
        }
        this.file = file;
        OperationDialog operationDialog = (OperationDialog)Operation.getProgressView();
        operationDialog.setInfo(READING_STR, file);
        operationDialog.setProgress(0, 0.0);
        System.gc();
        TextFile textFile = new TextFile(file, "UTF-8");
        textFile.addProgressListener(operationDialog);
        StringBuilder stringBuilder = textFile.read();
        TextFile.changeLineSeparators(stringBuilder, false);
        if (this.isXml(stringBuilder)) {
            this.fileKind = FileKind.XML;
            this.parseXml(stringBuilder);
        } else {
            this.fileKind = FileKind.TEXT;
            this.parseText(stringBuilder, list);
        }
        if (list.isEmpty()) {
            this.timestamp = file.lastModified();
        }
    }

    public void write(FileEx fileEx, boolean bl) throws AppException {
        if (fileEx != null) {
            this.file = fileEx.file;
            if (fileEx.fileKind != null) {
                this.fileKind = fileEx.fileKind;
            }
        }
        this.write(bl);
    }

    public void writeImage(File file) throws AppException {
        OperationDialog operationDialog = (OperationDialog)Operation.getProgressView();
        operationDialog.setInfo(WRITING_STR, file);
        operationDialog.setProgress(0, -1.0);
        PngOutputFile pngOutputFile = new PngOutputFile(file, this.getImage());
        pngOutputFile.addProgressListener(operationDialog);
        pngOutputFile.write(FileWritingMode.USE_TEMP_FILE);
    }

    public void parseStartupParam(String string, String string2, int n) {
        try {
            if (string.equals(X_INTERVAL_KEY)) {
                this.setXInterval(this.parseInterval(string2));
            } else if (string.equals(Y_INTERVAL_KEY)) {
                this.setYInterval(this.parseInterval(string2));
            } else if (string.equals(FUNCTION_KEY) && !this.isFull()) {
                Color color = AppConfig.getInstance().getFunctionColour(n++);
                this.functions.add(this.parseFunction(string2, color));
            }
        }
        catch (AppException appException) {
            App.getInstance().showErrorMessage("FuncPlotter", appException);
        }
    }

    public void updateCommands() {
        int n = this.getSelectedIndex();
        boolean bl = this.hasFunctions() && n >= 0;
        boolean bl2 = bl && !this.getFunction(n).isVisible();
        boolean bl3 = this.getView() != null;
        Command.setAllEnabled(true);
        Command.UNDO.setEnabled(this.editList.canUndo());
        Command.REDO.setEnabled(this.editList.canRedo());
        Command.CLEAR_EDIT_LIST.setEnabled(!this.editList.isEmpty());
        Command.ADD_FUNCTION.setEnabled(!this.isFull());
        Command.EDIT_FUNCTION.setEnabled(bl);
        Command.COPY_FUNCTION.setEnabled(AppConfig.getInstance().hasPermissionAccessClipboard() && bl);
        Command command = Command.HIDE_SHOW_FUNCTION;
        command.setEnabled(bl);
        command.putValue("Name", bl2 ? "Show" : "Hide");
        command.putValue("ShortDescription", bl2 ? "Show the selected function" : "Hide the selected function");
        Command.DELETE_FUNCTION.setEnabled(bl);
        Command.CONFIRM_DELETE_FUNCTION.setEnabled(bl);
        Command.CLEAR_FUNCTIONS.setEnabled(this.hasFunctions());
        Command.REVERSE_FUNCTIONS.setEnabled(this.getNumFunctions() > 1);
        Command.SHOW_GRID.setEnabled(bl3);
        Command.SHOW_GRID.setSelected(bl3 ? this.getView().getPlotPanel().isGridVisible() : false);
    }

    public void executeCommand(Command command) {
        this.executingCommand = true;
        Edit edit = null;
        try {
            try {
                switch (command) {
                    case UNDO: {
                        edit = this.doUndo();
                        break;
                    }
                    case REDO: {
                        edit = this.doRedo();
                        break;
                    }
                    case CLEAR_EDIT_LIST: {
                        edit = this.doClearEditList();
                        break;
                    }
                    case EDIT_COMMENT: {
                        edit = this.doEditComment();
                        break;
                    }
                    case ADD_FUNCTION: {
                        edit = this.doAddFunction();
                        break;
                    }
                    case EDIT_FUNCTION: {
                        edit = this.doEditFunction();
                        break;
                    }
                    case COPY_FUNCTION: {
                        edit = this.doCopyFunction();
                        break;
                    }
                    case HIDE_SHOW_FUNCTION: {
                        edit = this.doHideShowFunction();
                        break;
                    }
                    case DELETE_FUNCTION: {
                        edit = this.doDeleteFunction();
                        break;
                    }
                    case CONFIRM_DELETE_FUNCTION: {
                        edit = this.doConfirmDeleteFunction();
                        break;
                    }
                    case CLEAR_FUNCTIONS: {
                        edit = this.doClearFunctions();
                        break;
                    }
                    case MOVE_FUNCTION: {
                        edit = this.doMoveFunction();
                        break;
                    }
                    case REVERSE_FUNCTIONS: {
                        edit = this.doReverseFunctions();
                        break;
                    }
                    case SCROLL_LEFT: {
                        edit = this.doScrollLeft();
                        break;
                    }
                    case SCROLL_RIGHT: {
                        edit = this.doScrollRight();
                        break;
                    }
                    case SCROLL_DOWN: {
                        edit = this.doScrollDown();
                        break;
                    }
                    case SCROLL_UP: {
                        edit = this.doScrollUp();
                        break;
                    }
                    case CENTRE_ON_ORIGIN: {
                        edit = this.doCentreOnOrigin();
                        break;
                    }
                    case X_ZOOM_OUT: {
                        edit = this.doXZoomOut();
                        break;
                    }
                    case X_ZOOM_IN: {
                        edit = this.doXZoomIn();
                        break;
                    }
                    case Y_ZOOM_OUT: {
                        edit = this.doYZoomOut();
                        break;
                    }
                    case Y_ZOOM_IN: {
                        edit = this.doYZoomIn();
                        break;
                    }
                    case SET_X_INTERVAL: {
                        edit = this.doSetXInterval();
                        break;
                    }
                    case SET_Y_INTERVAL: {
                        edit = this.doSetYInterval();
                        break;
                    }
                    case SET_INTERVALS: {
                        edit = this.doSetIntervals();
                        break;
                    }
                    case SHOW_GRID: {
                        edit = this.doShowGrid();
                    }
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new AppException(ErrorId.NOT_ENOUGH_MEMORY_TO_PERFORM_COMMAND);
            }
        }
        catch (AppException appException) {
            App.getInstance().showErrorMessage("FuncPlotter", appException);
        }
        if (edit != null) {
            this.editList.addEdit(edit);
        }
        this.updateView(ViewComponent.BUTTONS);
        MainWindow mainWindow = FunctionDocument.getWindow();
        if (mainWindow != null) {
            App.getInstance().updateTabText(this);
            mainWindow.updateTitleAndMenus();
        }
        this.executingCommand = false;
    }

    private FunctionView getView() {
        return App.getInstance().getView(this);
    }

    private FunctionView.FunctionList getFunctionList() {
        return this.getView().getFunctionList();
    }

    private int getSelectedIndex() {
        return this.getView() == null ? -1 : this.getFunctionList().getSelectedIndex();
    }

    private void setXInterval(PlotInterval plotInterval) {
        this.xInterval = new PlotInterval(plotInterval);
        this.updateView(ViewComponent.X_INTERVAL);
    }

    private void setYInterval(PlotInterval plotInterval) {
        this.yInterval = new PlotInterval(plotInterval);
        this.updateView(ViewComponent.Y_INTERVAL);
    }

    private Edit setXIntervalEdit(PlotInterval plotInterval) {
        Edit.XInterval xInterval = null;
        if (plotInterval.isValid()) {
            xInterval = new Edit.XInterval(this.xInterval, plotInterval);
            this.setXInterval(plotInterval);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        return xInterval;
    }

    private Edit setYIntervalEdit(PlotInterval plotInterval) {
        Edit.YInterval yInterval = null;
        if (plotInterval.isValid()) {
            yInterval = new Edit.YInterval(this.yInterval, plotInterval);
            this.setYInterval(plotInterval);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        return yInterval;
    }

    private Edit setIntervals(PlotInterval plotInterval, PlotInterval plotInterval2, boolean bl) {
        Edit.Compound compound = null;
        if (this.xStartInterval == null) {
            this.xStartInterval = new PlotInterval(this.xInterval);
        }
        if (this.yStartInterval == null) {
            this.yStartInterval = new PlotInterval(this.yInterval);
        }
        if (plotInterval.isValid() && plotInterval2.isValid()) {
            if (!(!bl || this.xStartInterval.equals(plotInterval) && this.yStartInterval.equals(plotInterval2))) {
                compound = new Edit.Compound();
                compound.addEdit(new Edit.XInterval(this.xStartInterval, plotInterval));
                compound.addEdit(new Edit.YInterval(this.yStartInterval, plotInterval2));
            }
            this.setXInterval(plotInterval);
            this.setYInterval(plotInterval2);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        if (bl) {
            this.xStartInterval = null;
            this.yStartInterval = null;
        }
        return compound;
    }

    private boolean isXml(CharSequence charSequence) {
        return charSequence.subSequence(0, Math.min(charSequence.length(), XML_PREFIX.length())).toString().equals(XML_PREFIX);
    }

    private boolean hasCommentNodes(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 8 && !this.hasCommentNodes(node)) continue;
            return true;
        }
        return false;
    }

    private void parseXml(StringBuilder stringBuilder) throws AppException {
        int n;
        Document document = XmlUtilities.createDocument(stringBuilder.toString());
        if (!XmlUtilities.getErrorHandler().isEmpty()) {
            throw new XmlValidationException((AppException.Id)ErrorId.INVALID_DOCUMENT, this.file, XmlUtilities.getErrorHandler().getErrorStrings());
        }
        Element element = document.getDocumentElement();
        String string = "functionList";
        if (!element.getNodeName().equals(string)) {
            throw new FileException((AppException.Id)ErrorId.UNEXPECTED_DOCUMENT_FORMAT, this.file);
        }
        String string2 = "xmlns";
        String string3 = string + "." + string2;
        String string4 = XmlUtilities.getAttribute(element, string2);
        if (string4 == null) {
            throw new XmlParseException((AppException.Id)ErrorId.NO_ATTRIBUTE, this.file, string3);
        }
        if (!string4.equals(NAMESPACE_STR) && !string4.equals(OLD_NAMESPACE_STR)) {
            throw new FileException((AppException.Id)ErrorId.UNEXPECTED_DOCUMENT_FORMAT, this.file);
        }
        string2 = "version";
        string3 = string + "." + string2;
        string4 = XmlUtilities.getAttribute(element, string2);
        if (string4 == null) {
            throw new XmlParseException((AppException.Id)ErrorId.NO_ATTRIBUTE, this.file, string3);
        }
        try {
            n = Integer.parseInt(string4);
            if (n < 0 || n > 0) {
                throw new FileException((AppException.Id)ErrorId.UNSUPPORTED_DOCUMENT_VERSION, this.file, string4);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new XmlParseException((AppException.Id)ErrorId.INVALID_ATTRIBUTE, this.file, string3, string4);
        }
        string2 = X_INTERVAL_KEY;
        string3 = string + "." + string2;
        string4 = XmlUtilities.getAttribute(element, string2);
        if (string4 != null) {
            try {
                this.xInterval = this.parseInterval(string4);
            }
            catch (AppException appException) {
                throw new XmlParseException(appException.getId(), this.file, string3, string4);
            }
        }
        string2 = Y_INTERVAL_KEY;
        string3 = string + "." + string2;
        string4 = XmlUtilities.getAttribute(element, string2);
        if (string4 != null) {
            try {
                this.yInterval = this.parseInterval(string4);
            }
            catch (AppException appException) {
                throw new XmlParseException(appException.getId(), this.file, string3, string4);
            }
        }
        n = 0;
        try {
            boolean bl = false;
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                String string5 = node.getNodeName();
                if (string5.equals(Comment.getElementName())) {
                    if (bl) {
                        throw new FileException((AppException.Id)ErrorId.MULTIPLE_COMMENT_ELEMENTS, this.file);
                    }
                    this.comment = new Comment((Element)node);
                    bl = true;
                    continue;
                }
                if (!string5.equals(FUNCTION_KEY)) continue;
                if (this.isFull()) {
                    throw new FileException((AppException.Id)ErrorId.TOO_MANY_FUNCTIONS, this.file);
                }
                Color color = AppConfig.getInstance().getFunctionColour(n++);
                this.functions.add(this.parseFunction((Element)node, color));
            }
        }
        catch (XmlParseException xmlParseException) {
            throw new XmlParseException(xmlParseException, this.file);
        }
        this.commented = this.hasCommentNodes(document);
    }

    private Function parseFunction(Element element, Color color) throws XmlParseException {
        String string = XmlUtilities.getElementPath(element);
        String string2 = "expression";
        String string3 = string + "." + string2;
        String string4 = XmlUtilities.getAttribute(element, string2);
        if (string4 == null) {
            throw new XmlParseException((AppException.Id)ErrorId.NO_ATTRIBUTE, string3);
        }
        Expression expression = null;
        try {
            expression = new Expression(string4);
        }
        catch (Expression.Exception exception) {
            throw new XmlParseException((AppException.Id)ErrorId.INVALID_ATTRIBUTE, string3, string4);
        }
        string2 = "colour";
        string3 = string + "." + string2;
        string4 = XmlUtilities.getAttribute(element, string2);
        Color color2 = color;
        if (string4 != null) {
            try {
                color2 = ColourUtilities.parseColour(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XmlParseException((AppException.Id)ErrorId.INVALID_ATTRIBUTE, string3, string4);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new XmlParseException((AppException.Id)ErrorId.ATTRIBUTE_OUT_OF_BOUNDS, string3, string4);
            }
        }
        return new Function(color2, expression);
    }

    private void parseText(StringBuilder stringBuilder, List<String> list) throws AppException {
        int n = 0;
        StringBuilder stringBuilder2 = new StringBuilder();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = null;
        TextState textState = TextState.COMMENT_FIRST_LINE;
        while (textState != TextState.DONE) {
            int n5;
            while (string == null) {
                if (n4 < stringBuilder.length()) {
                    n5 = n4;
                    if ((n4 = stringBuilder.indexOf("\n", n4)) < 0) {
                        n4 = stringBuilder.length();
                    }
                    string = stringBuilder.substring(n5, n4);
                    ++n4;
                    ++n3;
                    if (!string.isEmpty()) continue;
                    string = null;
                    continue;
                }
                textState = TextState.DONE;
                break;
            }
            switch (textState) {
                case COMMENT_FIRST_LINE: {
                    if (string.charAt(0) == '#') {
                        for (n5 = 1; n5 < string.length() && string.charAt(n5) == ' '; ++n5) {
                            ++n;
                        }
                        stringBuilder2.append(string.substring(n + 1));
                        string = null;
                        textState = TextState.COMMENT;
                        break;
                    }
                    textState = TextState.STATEMENT;
                    break;
                }
                case COMMENT: {
                    if (string.charAt(0) == '#') {
                        int n6;
                        n5 = Math.min(n + 1, string.length());
                        for (n6 = 1; n6 < n5 && string.charAt(n6) == ' '; ++n6) {
                        }
                        stringBuilder2.append('\n');
                        stringBuilder2.append(string.substring(n6));
                        string = null;
                        break;
                    }
                    textState = TextState.STATEMENT;
                    break;
                }
                case STATEMENT: {
                    n5 = string.indexOf(35);
                    if (n5 >= 0) {
                        this.commented = true;
                        string = string.substring(0, n5);
                    }
                    if ((string = string.trim()).isEmpty()) {
                        string = null;
                        break;
                    }
                    textState = string.charAt(0) == '@' ? TextState.INTERVAL : TextState.FUNCTION;
                    break;
                }
                case INTERVAL: {
                    try {
                        if (string.length() < 2) {
                            throw new AppException(ErrorId.INVALID_INTERVAL_IDENTIFIER);
                        }
                        switch (Character.toLowerCase(string.charAt(1))) {
                            case 'x': {
                                this.xInterval = this.parseInterval(string.substring(2));
                                break;
                            }
                            case 'y': {
                                this.yInterval = this.parseInterval(string.substring(2));
                                break;
                            }
                            default: {
                                throw new AppException(ErrorId.INVALID_INTERVAL_IDENTIFIER);
                            }
                        }
                    }
                    catch (AppException appException) {
                        list.add(LINE_STR + n3 + ": " + appException);
                    }
                    string = null;
                    textState = TextState.STATEMENT;
                    break;
                }
                case FUNCTION: {
                    try {
                        Color color = AppConfig.getInstance().getFunctionColour(n2);
                        Function function = this.parseFunction(string, color);
                        ++n2;
                        if (this.isFull()) {
                            throw new AppException(ErrorId.TOO_MANY_FUNCTIONS);
                        }
                        this.functions.add(function);
                    }
                    catch (Expression.Exception exception) {
                        list.add(LINE_STR + n3 + " [" + (exception.getPos() + 1) + "]: " + exception);
                    }
                    catch (AppException appException) {
                        list.add(LINE_STR + n3 + ": " + appException);
                    }
                    string = null;
                    textState = TextState.STATEMENT;
                    break;
                }
                case DONE: {
                    this.comment.setText(stringBuilder2.toString());
                }
            }
        }
    }

    private PlotInterval parseInterval(String string) throws AppException {
        Object object;
        Object object2;
        String[] stringArray = string.split(",", -1);
        if (stringArray.length != 2) {
            throw new AppException(ErrorId.INVALID_INTERVAL);
        }
        BigDecimal bigDecimal = null;
        try {
            object2 = stringArray[0].trim();
            bigDecimal = new BigDecimal((String)object2);
            double d = bigDecimal.doubleValue();
            if (d < -1.0E100 || d > 1.0E100) {
                throw new AppException(ErrorId.INTERVAL_LOWER_ENDPOINT_OUT_OF_BOUNDS);
            }
            if (PlotInterval.hasTooManySignificantDigits((String)object2)) {
                throw new AppException(ErrorId.INTERVAL_LOWER_ENDPOINT_HAS_TOO_MANY_SIGNIFICANT_DIGITS);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new AppException(ErrorId.INVALID_INTERVAL_LOWER_ENDPOINT);
        }
        object2 = null;
        try {
            object = stringArray[1].trim();
            object2 = new BigDecimal((String)object);
            double d = ((BigDecimal)object2).doubleValue();
            if (d < -1.0E100 || d > 1.0E100) {
                throw new AppException(ErrorId.INTERVAL_UPPER_ENDPOINT_OUT_OF_BOUNDS);
            }
            if (PlotInterval.hasTooManySignificantDigits((String)object)) {
                throw new AppException(ErrorId.INTERVAL_UPPER_ENDPOINT_HAS_TOO_MANY_SIGNIFICANT_DIGITS);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new AppException(ErrorId.INVALID_INTERVAL_UPPER_ENDPOINT);
        }
        object = new PlotInterval(bigDecimal, (BigDecimal)object2);
        if (((PlotInterval)object).getLowerEndpoint() >= ((PlotInterval)object).getUpperEndpoint()) {
            throw new AppException(ErrorId.INTERVAL_ENDPOINTS_OUT_OF_ORDER);
        }
        return object;
    }

    private Function parseFunction(String string, Color color) throws AppException {
        int n = string.indexOf(59);
        if (n < 0) {
            n = string.length();
        }
        String string2 = string.substring(0, n);
        Expression expression = new Expression(string2);
        if (n < string.length()) {
            try {
                color = ColourUtilities.parseColour(string.substring(++n).trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AppException(ErrorId.INVALID_COLOUR);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new AppException(ErrorId.COLOUR_COMPONENT_OUT_OF_BOUNDS);
            }
        }
        return new Function(color, expression);
    }

    private void write(boolean bl) throws AppException {
        CharSequence charSequence = null;
        switch (this.fileKind) {
            case XML: {
                charSequence = this.getXml(bl);
                break;
            }
            case TEXT: {
                charSequence = this.getText(bl);
            }
        }
        OperationDialog operationDialog = (OperationDialog)Operation.getProgressView();
        operationDialog.setInfo(WRITING_STR, this.file);
        operationDialog.setProgress(0, 0.0);
        TextFile textFile = new TextFile(this.file, "UTF-8");
        textFile.addProgressListener(operationDialog);
        textFile.write(charSequence, FileWritingMode.USE_TEMP_FILE);
        this.timestamp = this.file.lastModified();
        this.editList.reset();
    }

    private String getXml(boolean bl) throws AppException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        XmlWriter xmlWriter = new XmlWriter(charArrayWriter);
        xmlWriter.setLineSeparator(null);
        try {
            xmlWriter.writeXmlDeclaration(XML_VERSION_STR, "UTF-8", XmlWriter.Standalone.NO);
            ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>();
            arrayList.add(new XmlWriter.Attribute("xmlns", NAMESPACE_STR));
            arrayList.add(new XmlWriter.Attribute("version", 0));
            arrayList.add(new XmlWriter.Attribute(X_INTERVAL_KEY, this.xInterval, true));
            arrayList.add(new XmlWriter.Attribute(Y_INTERVAL_KEY, this.yInterval, true));
            xmlWriter.writeElementStart("functionList", arrayList, 0, true, true);
            if (!this.comment.isEmpty()) {
                this.comment.write(xmlWriter, 2, 4);
            }
            for (Function function : this.functions) {
                arrayList.clear();
                arrayList.add(new XmlWriter.Attribute("expression", function.getExpression(), true));
                if (bl) {
                    arrayList.add(new XmlWriter.Attribute("colour", ColourUtilities.colourToRgbString(function.getColour())));
                }
                xmlWriter.writeEmptyElement(FUNCTION_KEY, arrayList, 2, true);
            }
            xmlWriter.writeElementEnd("functionList", 0);
        }
        catch (IOException iOException) {
            throw new FileException((AppException.Id)ErrorId.ERROR_WRITING_FILE, this.file, iOException);
        }
        return charArrayWriter.toString();
    }

    private StringBuilder getText(boolean bl) {
        String string = System.getProperty("line.separator", "\n");
        StringBuilder stringBuilder = new StringBuilder(1024);
        if (!this.comment.isEmpty()) {
            String string2 = this.comment.getText();
            for (int i = 0; i < string2.length(); ++i) {
                int n = i;
                if ((i = string2.indexOf(10, n)) < 0) {
                    i = string2.length();
                }
                stringBuilder.append('#');
                if (n < i) {
                    stringBuilder.append(' ');
                    stringBuilder.append(string2.substring(n, i));
                }
                stringBuilder.append(string);
            }
        }
        stringBuilder.append('@');
        stringBuilder.append("x ");
        stringBuilder.append(this.xInterval);
        stringBuilder.append(string);
        stringBuilder.append('@');
        stringBuilder.append("y ");
        stringBuilder.append(this.yInterval);
        stringBuilder.append(string);
        for (Function function : this.functions) {
            stringBuilder.append(function.toString());
            if (bl) {
                stringBuilder.append(';');
                stringBuilder.append(' ');
                stringBuilder.append(ColourUtilities.colourToRgbString(function.getColour()));
            }
            stringBuilder.append(string);
        }
        return stringBuilder;
    }

    private BufferedImage getImage() throws AppException {
        PlotPanel plotPanel = this.getView().getPlotPanel();
        Dimension dimension = plotPanel.getPreferredSize();
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, 1);
        plotPanel.drawPanel(bufferedImage.getGraphics());
        return bufferedImage;
    }

    private void updateView(ViewComponent ... viewComponentArray) {
        FunctionView functionView = this.getView();
        if (functionView != null) {
            block7: for (ViewComponent viewComponent : viewComponentArray) {
                switch (viewComponent) {
                    case PLOT: {
                        functionView.updatePlot();
                        continue block7;
                    }
                    case BUTTONS: {
                        functionView.updateButtons();
                        continue block7;
                    }
                    case X_INTERVAL: {
                        functionView.updateXInterval();
                        continue block7;
                    }
                    case Y_INTERVAL: {
                        functionView.updateYInterval();
                        continue block7;
                    }
                    case INTERVALS: {
                        functionView.updateIntervals();
                    }
                }
            }
        }
    }

    private Edit doUndo() {
        Edit edit = this.editList.getUndo();
        if (edit != null) {
            int n = this.getSelectedIndex();
            edit.undo(this);
            if (n < this.getNumFunctions()) {
                this.getFunctionList().setSelectedIndex(n);
            }
            this.updateView(ViewComponent.PLOT, ViewComponent.INTERVALS);
        }
        return null;
    }

    private Edit doRedo() {
        Edit edit = this.editList.getRedo();
        if (edit != null) {
            int n = this.getSelectedIndex();
            edit.redo(this);
            if (n < this.getNumFunctions()) {
                this.getFunctionList().setSelectedIndex(n);
            }
            this.updateView(ViewComponent.PLOT, ViewComponent.INTERVALS);
        }
        return null;
    }

    private Edit doClearEditList() {
        if (JOptionPane.showOptionDialog(FunctionDocument.getWindow(), CLEAR_EDIT_LIST_STR, "FuncPlotter", 2, 3, null, CC_OPTION_STRS, CC_OPTION_STRS[1]) == 0) {
            this.editList.clear();
            System.gc();
        }
        return null;
    }

    private Edit doEditComment() {
        Edit.Comment comment = null;
        String string = CommentDialog.showDialog(FunctionDocument.getWindow(), COMMENT_STR, this.comment.getText());
        if (string != null && !string.equals(this.comment.getText())) {
            comment = new Edit.Comment(this.comment.getText(), string);
            this.comment.setText(string);
        }
        return comment;
    }

    private Edit doAddFunction() {
        Edit.Add add = null;
        if (!this.isFull()) {
            Color color = AppConfig.getInstance().getFunctionColour(this.getNumFunctions());
            FunctionDialog functionDialog = FunctionDialog.showDialog(FunctionDocument.getWindow(), ADD_FUNCTION_STR, color, null);
            if (functionDialog.isAccepted()) {
                Function function = new Function(functionDialog.getColour(), functionDialog.getExpression());
                add = new Edit.Add(this.getNumFunctions(), function);
                this.getFunctionList().addElement(function);
            }
        }
        return add;
    }

    private Edit doEditFunction() {
        Edit.Compound compound = null;
        int n = this.getSelectedIndex();
        if (this.hasFunctions() && n >= 0) {
            Function function = this.getFunction(n);
            FunctionDialog functionDialog = FunctionDialog.showDialog(FunctionDocument.getWindow(), EDIT_FUNCTION_STR, function.getColour(), function.getExpression().toString());
            if (functionDialog.isAccepted()) {
                Function function2 = new Function(functionDialog.getColour(), functionDialog.getExpression(), function.isVisible());
                compound = new Edit.Compound();
                compound.addEdit(new Edit.Remove(n, function));
                compound.addEdit(new Edit.Add(n, function2));
                this.getFunctionList().setElement(n, function2);
            }
        }
        return compound;
    }

    private Edit doCopyFunction() throws AppException {
        int n = this.getSelectedIndex();
        if (this.hasFunctions() && n >= 0) {
            StringSelection stringSelection = new StringSelection(this.getFunction(n).getExpression().toString());
            try {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            }
            catch (IllegalStateException illegalStateException) {
                throw new AppException((AppException.Id)ErrorId.CLIPBOARD_UNAVAILABLE, (Throwable)illegalStateException);
            }
        }
        return null;
    }

    private Edit doHideShowFunction() {
        int n = this.getSelectedIndex();
        if (this.hasFunctions() && n >= 0) {
            Function function;
            function.setVisible(!(function = this.getFunction(n)).isVisible());
            this.getFunctionList().setElement(n, function);
        }
        return null;
    }

    private Edit doDeleteFunction() {
        Edit.Remove remove = null;
        int n = this.getSelectedIndex();
        if (this.hasFunctions() && n >= 0) {
            remove = new Edit.Remove(n, this.getFunction(n));
            this.getFunctionList().removeElement(n);
        }
        return remove;
    }

    private Edit doConfirmDeleteFunction() {
        Edit edit = null;
        if (JOptionPane.showOptionDialog(FunctionDocument.getWindow(), DELETE_MESSAGE_STR, "FuncPlotter | Delete Function", 2, 3, null, DC_OPTION_STRS, DC_OPTION_STRS[0]) == 0) {
            edit = this.doDeleteFunction();
        }
        return edit;
    }

    private Edit doClearFunctions() {
        Edit.Compound compound = null;
        if (this.hasFunctions() && JOptionPane.showOptionDialog(FunctionDocument.getWindow(), DELETE_ALL_MESSAGE_STR, "FuncPlotter | Delete All Functions", 2, 3, null, DC_OPTION_STRS, DC_OPTION_STRS[1]) == 0) {
            compound = new Edit.Compound();
            for (int i = this.getNumFunctions() - 1; i >= 0; --i) {
                compound.addEdit(new Edit.Remove(i, this.getFunction(i)));
            }
            this.getFunctionList().setElements((Function[])null);
        }
        return compound;
    }

    private Edit doMoveFunction() {
        int n;
        Edit.Compound compound = null;
        int n2 = this.getSelectedIndex();
        int n3 = (Integer)Command.MOVE_FUNCTION.getValue("index");
        int n4 = n = n3 > n2 ? n3 - 1 : n3;
        if (n != n2) {
            Function function = this.getFunction(n2);
            compound = new Edit.Compound();
            compound.addEdit(new Edit.Remove(n2, function));
            compound.addEdit(new Edit.Add(n, function));
            this.getFunctionList().moveElement(n2, n3);
        }
        return compound;
    }

    private Edit doReverseFunctions() {
        Edit.Compound compound = null;
        if (this.getNumFunctions() > 1) {
            int n;
            int n2 = this.getSelectedIndex();
            compound = new Edit.Compound();
            ArrayList<Function> arrayList = new ArrayList<Function>(this.functions);
            Collections.reverse(arrayList);
            for (n = this.getNumFunctions() - 1; n >= 0; --n) {
                compound.addEdit(new Edit.Remove(n, this.getFunction(n)));
            }
            for (n = 0; n < this.getNumFunctions(); ++n) {
                compound.addEdit(new Edit.Add(n, (Function)arrayList.get(n)));
            }
            this.getFunctionList().setElements(arrayList);
            this.getFunctionList().setSelectedIndex(n2);
        }
        return compound;
    }

    private Edit doScrollLeft() {
        double d = this.getView().getPlotPanel().getXScrollIncrement();
        return this.setXIntervalEdit(new PlotInterval(this.xInterval.getLowerEndpoint() - d, this.xInterval.getUpperEndpoint() - d));
    }

    private Edit doScrollRight() {
        double d = this.getView().getPlotPanel().getXScrollIncrement();
        return this.setXIntervalEdit(new PlotInterval(this.xInterval.getLowerEndpoint() + d, this.xInterval.getUpperEndpoint() + d));
    }

    private Edit doScrollDown() {
        double d = this.getView().getPlotPanel().getYScrollIncrement();
        return this.setYIntervalEdit(new PlotInterval(this.yInterval.getLowerEndpoint() - d, this.yInterval.getUpperEndpoint() - d));
    }

    private Edit doScrollUp() {
        double d = this.getView().getPlotPanel().getYScrollIncrement();
        return this.setYIntervalEdit(new PlotInterval(this.yInterval.getLowerEndpoint() + d, this.yInterval.getUpperEndpoint() + d));
    }

    private Edit doCentreOnOrigin() {
        Edit.Compound compound = null;
        double d = this.xInterval.getHalfInterval();
        PlotInterval plotInterval = new PlotInterval(-d, d);
        double d2 = this.yInterval.getHalfInterval();
        PlotInterval plotInterval2 = new PlotInterval(-d2, d2);
        if (plotInterval.isValid() && plotInterval2.isValid()) {
            compound = new Edit.Compound();
            compound.addEdit(new Edit.XInterval(this.xInterval, plotInterval));
            compound.addEdit(new Edit.YInterval(this.yInterval, plotInterval2));
            this.setIntervals(plotInterval, plotInterval2);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        return compound;
    }

    private Edit doXZoomOut() {
        double d = this.xInterval.getMedian();
        double d2 = this.xInterval.getHalfInterval() * FunctionView.getXZoomFactor();
        return this.setXIntervalEdit(new PlotInterval(d - d2, d + d2));
    }

    private Edit doXZoomIn() {
        double d = this.xInterval.getMedian();
        double d2 = this.xInterval.getHalfInterval() / FunctionView.getXZoomFactor();
        return this.setXIntervalEdit(new PlotInterval(d - d2, d + d2));
    }

    private Edit doYZoomOut() {
        double d = this.yInterval.getMedian();
        double d2 = this.yInterval.getHalfInterval() * FunctionView.getYZoomFactor();
        return this.setYIntervalEdit(new PlotInterval(d - d2, d + d2));
    }

    private Edit doYZoomIn() {
        double d = this.yInterval.getMedian();
        double d2 = this.yInterval.getHalfInterval() / FunctionView.getYZoomFactor();
        return this.setYIntervalEdit(new PlotInterval(d - d2, d + d2));
    }

    private Edit doSetXInterval() {
        return this.setXIntervalEdit((PlotInterval)Command.SET_X_INTERVAL.getValue(X_INTERVAL_KEY));
    }

    private Edit doSetYInterval() {
        return this.setYIntervalEdit((PlotInterval)Command.SET_Y_INTERVAL.getValue(Y_INTERVAL_KEY));
    }

    private Edit doSetIntervals() {
        Command command = Command.SET_INTERVALS;
        PlotInterval plotInterval = (PlotInterval)command.getValue(X_INTERVAL_KEY);
        PlotInterval plotInterval2 = (PlotInterval)command.getValue(Y_INTERVAL_KEY);
        boolean bl = (Boolean)command.getValue("end");
        return this.setIntervals(plotInterval, plotInterval2, bl);
    }

    private Edit doShowGrid() {
        PlotPanel plotPanel;
        plotPanel.setGridVisible(!(plotPanel = this.getView().getPlotPanel()).isGridVisible());
        return null;
    }

    private static class EditList
    extends LinkedList<Edit> {
        private int currentIndex;
        private int unchangedIndex;

        private EditList() {
        }

        @Override
        public void clear() {
            super.clear();
            this.currentIndex = 0;
            this.unchangedIndex = 0;
        }

        public Edit getUndo() {
            return this.canUndo() ? (Edit)this.get(--this.currentIndex) : null;
        }

        public Edit getRedo() {
            return this.canRedo() ? (Edit)this.get(this.currentIndex++) : null;
        }

        public boolean canUndo() {
            return this.currentIndex > 0;
        }

        public boolean canRedo() {
            return this.currentIndex < this.size();
        }

        public boolean isChanged() {
            return this.currentIndex != this.unchangedIndex;
        }

        public void addEdit(Edit edit) {
            while (this.size() > this.currentIndex) {
                this.removeLast();
            }
            if (this.unchangedIndex > this.currentIndex) {
                this.unchangedIndex = -1;
            }
            this.mergeXIntervals(edit);
            this.mergeYIntervals(edit);
            this.add(edit);
            ++this.currentIndex;
        }

        public void reset() {
            while (this.size() > this.currentIndex) {
                this.removeLast();
            }
            this.unchangedIndex = this.currentIndex;
        }

        private void mergeXIntervals(Edit edit) {
            if (edit instanceof Edit.XInterval) {
                Edit.XInterval xInterval = (Edit.XInterval)edit;
                while (this.canUndo() && this.getLast() instanceof Edit.XInterval) {
                    Edit.XInterval xInterval2 = (Edit.XInterval)this.getLast();
                    if (xInterval.timestamp - xInterval2.timestamp > 500L) break;
                    xInterval.oldInterval = xInterval2.oldInterval;
                    this.removeLast();
                    --this.currentIndex;
                }
            }
        }

        private void mergeYIntervals(Edit edit) {
            if (edit instanceof Edit.YInterval) {
                Edit.YInterval yInterval = (Edit.YInterval)edit;
                while (this.canUndo() && this.getLast() instanceof Edit.YInterval) {
                    Edit.YInterval yInterval2 = (Edit.YInterval)this.getLast();
                    if (yInterval.timestamp - yInterval2.timestamp > 500L) break;
                    yInterval.oldInterval = yInterval2.oldInterval;
                    this.removeLast();
                    --this.currentIndex;
                }
            }
        }
    }

    public static abstract class Edit {
        private Edit() {
        }

        public abstract void undo(FunctionDocument var1);

        public abstract void redo(FunctionDocument var1);

        private static class Compound
        extends Edit {
            private List<Edit> edits = new ArrayList<Edit>();

            private Compound() {
            }

            @Override
            public void undo(FunctionDocument functionDocument) {
                for (int i = this.edits.size() - 1; i >= 0; --i) {
                    this.edits.get(i).undo(functionDocument);
                }
            }

            @Override
            public void redo(FunctionDocument functionDocument) {
                for (Edit edit : this.edits) {
                    edit.redo(functionDocument);
                }
            }

            public void addEdit(Edit edit) {
                this.edits.add(edit);
            }
        }

        private static class Comment
        extends Edit {
            private String oldText;
            private String newText;

            private Comment(String string, String string2) {
                this.oldText = string;
                this.newText = string2;
            }

            @Override
            public void undo(FunctionDocument functionDocument) {
                functionDocument.comment.setText(this.oldText);
            }

            @Override
            public void redo(FunctionDocument functionDocument) {
                functionDocument.comment.setText(this.newText);
            }
        }

        private static class YInterval
        extends Edit {
            private PlotInterval oldInterval;
            private PlotInterval newInterval;
            private long timestamp;

            private YInterval(PlotInterval plotInterval, PlotInterval plotInterval2) {
                this.oldInterval = new PlotInterval(plotInterval);
                this.newInterval = new PlotInterval(plotInterval2);
                this.timestamp = System.currentTimeMillis();
            }

            @Override
            public void undo(FunctionDocument functionDocument) {
                functionDocument.setYInterval(this.oldInterval);
            }

            @Override
            public void redo(FunctionDocument functionDocument) {
                functionDocument.setYInterval(this.newInterval);
            }
        }

        private static class XInterval
        extends Edit {
            private PlotInterval oldInterval;
            private PlotInterval newInterval;
            private long timestamp;

            private XInterval(PlotInterval plotInterval, PlotInterval plotInterval2) {
                this.oldInterval = new PlotInterval(plotInterval);
                this.newInterval = new PlotInterval(plotInterval2);
                this.timestamp = System.currentTimeMillis();
            }

            @Override
            public void undo(FunctionDocument functionDocument) {
                functionDocument.setXInterval(this.oldInterval);
            }

            @Override
            public void redo(FunctionDocument functionDocument) {
                functionDocument.setXInterval(this.newInterval);
            }
        }

        private static class Remove
        extends Edit {
            private int index;
            private Function function;

            private Remove(int n, Function function) {
                this.index = n;
                this.function = function.clone();
            }

            @Override
            public void undo(FunctionDocument functionDocument) {
                functionDocument.getFunctionList().addElement(this.index, this.function);
            }

            @Override
            public void redo(FunctionDocument functionDocument) {
                functionDocument.getFunctionList().removeElement(this.index);
            }
        }

        private static class Add
        extends Edit {
            private int index;
            private Function function;

            private Add(int n, Function function) {
                this.index = n;
                this.function = function.clone();
            }

            @Override
            public void undo(FunctionDocument functionDocument) {
                functionDocument.getFunctionList().removeElement(this.index);
            }

            @Override
            public void redo(FunctionDocument functionDocument) {
                functionDocument.getFunctionList().addElement(this.index, this.function);
            }
        }
    }

    public static class FileEx {
        File file;
        FileKind fileKind;

        public FileEx(File file, FileKind fileKind) {
            this.file = file;
            this.fileKind = fileKind;
        }
    }

    private static enum ErrorId implements AppException.Id
    {
        FILE_DOES_NOT_EXIST("The file does not exist."),
        NOT_A_FILE("The pathname does not specify a file."),
        ERROR_WRITING_FILE("An error occurred when writing the file."),
        INVALID_DOCUMENT("The file is not a valid FuncPlotter document."),
        UNEXPECTED_DOCUMENT_FORMAT("The document does not have the expected format."),
        UNSUPPORTED_DOCUMENT_VERSION("The version of the document (%1) is not supported by this version of FuncPlotter."),
        NO_ATTRIBUTE("The required attribute is missing."),
        INVALID_ATTRIBUTE("The attribute is invalid."),
        ATTRIBUTE_OUT_OF_BOUNDS("The attribute value is out of bounds."),
        MULTIPLE_COMMENT_ELEMENTS("The file contains more than one comment element."),
        INVALID_INTERVAL_IDENTIFIER("The interval identifier is invalid."),
        INVALID_INTERVAL("The interval is invalid."),
        INVALID_INTERVAL_LOWER_ENDPOINT("The lower endpoint of the interval is invalid."),
        INTERVAL_LOWER_ENDPOINT_OUT_OF_BOUNDS("The lower endpoint of the interval must be between -1.0E100 and 1.0E100."),
        INTERVAL_LOWER_ENDPOINT_HAS_TOO_MANY_SIGNIFICANT_DIGITS("The lower endpoint of the interval must not have more than 12 significant digits."),
        INVALID_INTERVAL_UPPER_ENDPOINT("The upper endpoint of the interval is invalid."),
        INTERVAL_UPPER_ENDPOINT_OUT_OF_BOUNDS("The upper endpoint of the interval must be between -1.0E100 and 1.0E100."),
        INTERVAL_UPPER_ENDPOINT_HAS_TOO_MANY_SIGNIFICANT_DIGITS("The upper endpoint of the interval must not have more than 12 significant digits."),
        INTERVAL_ENDPOINTS_OUT_OF_ORDER("The upper endpoint of the interval is less than or equal to the lower endpoint."),
        TOO_MANY_FUNCTIONS("The document contains too many functions."),
        INVALID_COLOUR("The colour is invalid."),
        COLOUR_COMPONENT_OUT_OF_BOUNDS("Colour component values must be between 0 and 255."),
        CLIPBOARD_UNAVAILABLE("The clipboard is currently unavailable."),
        NOT_ENOUGH_MEMORY_TO_PERFORM_COMMAND("There was not enough memory to perform the command.\nClearing the list of undo/redo actions may make more memory available.");

        private String message;

        private ErrorId(String string2) {
            this.message = string2;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    static enum Command implements Action
    {
        UNDO("undo", "Undo", KeyStroke.getKeyStroke(90, 128)),
        REDO("redo", "Redo", KeyStroke.getKeyStroke(89, 128)),
        CLEAR_EDIT_LIST("clearEditList", "Clear Undo/Redo Actions"),
        EDIT_COMMENT("editComment", "Comment...", KeyStroke.getKeyStroke(77, 128)),
        ADD_FUNCTION("addFunction", "Add...", "Add a function"),
        EDIT_FUNCTION("editFunction", "Edit...", "Edit the selected function"),
        COPY_FUNCTION("copyFunction", "Copy", "Copy the selected function to the clipboard"),
        HIDE_SHOW_FUNCTION("hideShowFunction", "Hide"),
        DELETE_FUNCTION("deleteFunction", "Delete", "Delete the selected function"),
        CONFIRM_DELETE_FUNCTION("confirmDeleteFunction"),
        CLEAR_FUNCTIONS("clearFunctions", "Clear", "Delete all functions"),
        MOVE_FUNCTION("moveFunction"),
        REVERSE_FUNCTIONS("reverseFunctions", "Reverse Order of Functions"),
        SCROLL_LEFT("scrollLeft", AppIcon.ARROW_LEFT, "Scroll left"),
        SCROLL_RIGHT("scrollRight", AppIcon.ARROW_RIGHT, "Scroll right"),
        SCROLL_DOWN("scrollDown", AppIcon.ARROW_DOWN, "Scroll down"),
        SCROLL_UP("scrollUp", AppIcon.ARROW_UP, "Scroll up"),
        CENTRE_ON_ORIGIN("centreOnOrigin", AppIcon.ORIGIN, "Centre on origin"),
        X_ZOOM_OUT("xZoomOut", AppIcon.ZOOM_OUT, "x zoom out"),
        X_ZOOM_IN("xZoomIn", AppIcon.ZOOM_IN, "x zoom in"),
        Y_ZOOM_OUT("yZoomOut", AppIcon.ZOOM_OUT, "y zoom out"),
        Y_ZOOM_IN("yZoomIn", AppIcon.ZOOM_IN, "y zoom in"),
        SET_X_INTERVAL("setXInterval"),
        SET_Y_INTERVAL("setYInterval"),
        SET_INTERVALS("setIntervals"),
        SHOW_GRID("showGrid", "Grid", KeyStroke.getKeyStroke(71, 128));

        public static final String UNDO_STR = "Undo the previous edit";
        public static final String REDO_STR = "Redo the next edit";
        public static final String HIDE_STR = "Hide";
        public static final String SHOW_STR = "Show";
        public static final String HIDE_FUNCTION_STR = "Hide the selected function";
        public static final String SHOW_FUNCTION_STR = "Show the selected function";
        private functionplotter.util.Command command = new functionplotter.util.Command(this);

        private Command(String string2) {
            this.putValue("ActionCommandKey", string2);
        }

        private Command(String string2, String string3) {
            this(string2);
            this.putValue("Name", string3);
        }

        private Command(String string2, String string3, String string4) {
            this(string2, string3);
            this.putValue("ShortDescription", string4);
        }

        private Command(String string2, ImageIcon imageIcon, String string3) {
            this(string2);
            this.putValue("SwingLargeIconKey", imageIcon);
            this.putValue("ShortDescription", string3);
        }

        private Command(String string2, String string3, KeyStroke keyStroke) {
            this(string2, string3);
            this.putValue("AcceleratorKey", keyStroke);
        }

        public static void setAllEnabled(boolean bl) {
            for (Command command : Command.values()) {
                command.setEnabled(bl);
            }
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.command.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public Object getValue(String string) {
            return this.command.getValue(string);
        }

        @Override
        public boolean isEnabled() {
            return this.command.isEnabled();
        }

        @Override
        public void putValue(String string, Object object) {
            this.command.putValue(string, object);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.command.removePropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void setEnabled(boolean bl) {
            this.command.setEnabled(bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FunctionDocument functionDocument = App.getInstance().getDocument();
            if (functionDocument != null) {
                functionDocument.executeCommand(this);
            }
        }

        public void setSelected(boolean bl) {
            this.putValue("SwingSelectedKey", new Boolean(bl));
        }

        public void execute() {
            this.actionPerformed(null);
        }

        static {
            if (App.getInstance().isApplet()) {
                UNDO.putValue("ShortDescription", UNDO_STR);
                REDO.putValue("ShortDescription", REDO_STR);
            }
        }

        static interface Property {
            public static final String END = "end";
            public static final String INDEX = "index";
            public static final String X_INTERVAL = "xInterval";
            public static final String Y_INTERVAL = "yInterval";
        }
    }

    private static interface AttrName {
        public static final String COLOUR = "colour";
        public static final String EXPRESSION = "expression";
        public static final String VERSION = "version";
        public static final String XMLNS = "xmlns";
        public static final String X_INTERVAL = "xInterval";
        public static final String Y_INTERVAL = "yInterval";
    }

    private static interface ElementName {
        public static final String FUNCTION = "function";
        public static final String FUNCTION_LIST = "functionList";
    }

    private static enum TextState {
        COMMENT_FIRST_LINE,
        COMMENT,
        STATEMENT,
        INTERVAL,
        FUNCTION,
        DONE;

    }

    private static enum ViewComponent {
        PLOT,
        BUTTONS,
        X_INTERVAL,
        Y_INTERVAL,
        INTERVALS;

    }
}

