/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.util.math;

public class IntegerMutable {
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    private int m_value;

    public IntegerMutable(int value) {
        this.m_value = value;
    }

    public void add(int i) throws ArithmeticException {
        int oldval = this.m_value;
        this.m_value += i;
        if (oldval > this.m_value) {
            this.m_value = oldval;
            throw new ArithmeticException("Overflow detected. Value saved unchanged.");
        }
    }

    public void add(Integer i) throws ArithmeticException {
        this.add((int)i);
    }

    public void add(IntegerMutable i) throws ArithmeticException {
        this.add(i.getValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerMutable other = (IntegerMutable)obj;
        return this.m_value == other.m_value;
    }

    public int getValue() {
        return this.m_value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.m_value;
        return result;
    }

    public int intValue() {
        return this.m_value;
    }

    public void setValue(int value) {
        this.m_value = value;
    }

    public void sub(int i) throws ArithmeticException {
        int oldval = this.m_value;
        this.m_value -= i;
        if (oldval < this.m_value) {
            this.m_value = oldval;
            throw new ArithmeticException("Carry detected. Value saved unchanged.");
        }
    }

    public void sub(Integer i) throws ArithmeticException {
        this.sub((int)i);
    }

    public void sub(IntegerMutable i) throws ArithmeticException {
        this.sub(i.intValue());
    }

    public String toString() {
        return String.valueOf(this.m_value);
    }
}

