/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.reflection;

import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.reflection.ObjectRecorder;
import info.monitorenter.util.TimeStampedValue;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ObjRecorder2Trace2DAdapter
implements ChangeListener {
    private final String m_fieldname;
    private final ObjectRecorder m_inspector;
    private final long m_start = System.currentTimeMillis();
    private final ITrace2D m_view;

    public ObjRecorder2Trace2DAdapter(ITrace2D view, Object toinspect, String fieldname, long interval) {
        this.m_view = view;
        this.m_fieldname = fieldname;
        this.m_inspector = new ObjectRecorder(toinspect, interval);
        this.m_inspector.addChangeListener(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjRecorder2Trace2DAdapter other = (ObjRecorder2Trace2DAdapter)obj;
        if (this.m_fieldname == null ? other.m_fieldname != null : !this.m_fieldname.equals(other.m_fieldname)) {
            return false;
        }
        if (this.m_inspector == null ? other.m_inspector != null : !this.m_inspector.equals(other.m_inspector)) {
            return false;
        }
        if (this.m_start != other.m_start) {
            return false;
        }
        return !(this.m_view == null ? other.m_view != null : !this.m_view.equals(other.m_view));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_fieldname == null ? 0 : this.m_fieldname.hashCode());
        result = 31 * result + (this.m_inspector == null ? 0 : this.m_inspector.hashCode());
        result = 31 * result + (int)(this.m_start ^ this.m_start >>> 32);
        result = 31 * result + (this.m_view == null ? 0 : this.m_view.hashCode());
        return result;
    }

    public void setInterval(long interval) {
        this.m_inspector.setInterval(interval);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        TimeStampedValue last;
        try {
            last = this.m_inspector.getLastValue(this.m_fieldname);
        }
        catch (Exception f) {
            f.printStackTrace();
            return;
        }
        if (last != null) {
            double tmpx = last.getTime() - this.m_start;
            double tmpy = Double.parseDouble(last.getValue().toString());
            this.m_view.addPoint(tmpx, tmpy);
        }
    }
}

