/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.util;

import java.awt.Color;
import java.io.Serializable;

public class HSBColor
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 3257288036910903863L;
    protected double m_hue;
    protected double m_lum;
    protected double m_sat;
    protected double m_alpha;

    public static HSBColor rgbToHSB(Color color) {
        int cmax;
        int rgb = color.getRGB();
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        HSBColor ret = new HSBColor();
        int n = r >= g ? (r >= b ? r : b) : (cmax = g >= b ? g : b);
        int cmin = r <= g ? (r <= b ? r : b) : (g <= b ? g : b);
        ret.m_lum = (float)cmax / 255.0f;
        if (cmax != cmin) {
            float difference = cmax - cmin;
            ret.m_sat = difference / (float)cmax;
            ret.m_hue = r == cmax ? (double)((float)(g - b) / difference) : (g == cmax ? (double)((float)(b - r) / difference + 2.0f) : (double)((float)(r - g) / difference + 4.0f));
            ret.m_hue /= 6.0;
            if (ret.m_hue < 0.0) {
                ret.m_hue += 1.0;
            }
        } else {
            ret.m_sat = 0.0;
            ret.m_hue = 0.0;
        }
        ret.m_alpha = color.getAlpha();
        return ret;
    }

    private HSBColor() {
    }

    HSBColor(double hue, double saturation, double brightness) {
        this(hue, saturation, brightness, 255);
    }

    HSBColor(double hue, double saturation, double brightness, int alpha) {
        this.m_hue = hue;
        this.m_sat = saturation;
        this.m_lum = brightness;
        this.m_alpha = alpha;
    }

    public HSBColor(Color rgbcolor) {
        int cmax;
        int rgb = rgbcolor.getRGB();
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        int n = r >= g ? (r >= b ? r : b) : (cmax = g >= b ? g : b);
        int cmin = r <= g ? (r <= b ? r : b) : (g <= b ? g : b);
        this.m_lum = (float)cmax / 255.0f;
        if (cmax != cmin) {
            float difference = cmax - cmin;
            this.m_sat = difference / (float)cmax;
            this.m_hue = r == cmax ? (double)((float)(g - b) / difference) : (g == cmax ? (double)((float)(b - r) / difference) + 2.0 : (double)((float)(r - g) / difference) + 4.0);
            this.m_hue /= 6.0;
            if (this.m_hue < 0.0) {
                this.m_hue += 1.0;
            }
        } else {
            this.m_sat = 0.0;
            this.m_hue = 0.0;
        }
        this.m_alpha = rgbcolor.getAlpha();
    }

    public Object clone() {
        HSBColor result = null;
        try {
            result = (HSBColor)super.clone();
            result.m_hue = this.m_hue;
            result.m_lum = this.m_lum;
            result.m_sat = this.m_sat;
            result.m_alpha = this.m_alpha;
        }
        catch (CloneNotSupportedException e) {
            result = new HSBColor((float)this.m_hue, (float)this.m_sat, (float)this.m_lum, (int)Math.round(this.m_alpha));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HSBColor other = (HSBColor)obj;
        if (Double.doubleToLongBits(this.m_alpha) != Double.doubleToLongBits(other.m_alpha)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m_hue) != Double.doubleToLongBits(other.m_hue)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m_lum) != Double.doubleToLongBits(other.m_lum)) {
            return false;
        }
        return Double.doubleToLongBits(this.m_sat) == Double.doubleToLongBits(other.m_sat);
    }

    public Color getRGBColor() {
        int rgb = Color.HSBtoRGB((float)this.m_hue, (float)this.m_sat, (float)this.m_lum);
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        return new Color(r, g, b, (int)Math.round(this.m_alpha));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.m_alpha);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m_hue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m_lum);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m_sat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

