/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.demos;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.TracePoint2D;
import info.monitorenter.gui.chart.traces.Trace2DBijective;
import info.monitorenter.gui.chart.traces.Trace2DLtd;
import info.monitorenter.gui.chart.traces.Trace2DLtdReplacing;
import info.monitorenter.gui.chart.traces.Trace2DLtdSorted;
import info.monitorenter.gui.chart.traces.Trace2DReplacing;
import info.monitorenter.gui.chart.traces.Trace2DSimple;
import info.monitorenter.gui.chart.traces.Trace2DSorted;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;
import javax.swing.JFrame;

public final class TraceTester {
    public static void main(String[] args) {
        try {
            int j;
            int i;
            Class[] traces = new Class[]{Trace2DSimple.class, Trace2DBijective.class, Trace2DReplacing.class, Trace2DSorted.class, Trace2DLtd.class, Trace2DLtdReplacing.class, Trace2DLtdSorted.class};
            RandomPoints rand = new RandomPoints(0, 3, 0, 3);
            Chart2D test = new Chart2D();
            JFrame frame = new JFrame("TraceTester");
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            frame.getContentPane().add(test);
            frame.setSize(600, 500);
            frame.setLocation(200, 200);
            frame.setVisible(true);
            ITrace2D current = null;
            for (i = 0; i < traces.length; ++i) {
                current = (ITrace2D)traces[i].newInstance();
                test.addTrace(current);
                frame.setTitle("TraceTester: full-random, current: " + traces[i].getName());
                for (j = 0; j < 200; ++j) {
                    current.addPoint(rand.nextPoint());
                    Thread.sleep(50L);
                }
                Thread.sleep(2000L);
                test.removeTrace(current);
            }
            rand = new HalfRandomPoints(0, 3, 0, 3);
            for (i = 0; i < traces.length; ++i) {
                current = (ITrace2D)traces[i].newInstance();
                test.addTrace(current);
                frame.setTitle("TraceTester: repeating x 10 times, current: " + traces[i].getName());
                for (j = 0; j < 200; ++j) {
                    current.addPoint(rand.nextPoint());
                    Thread.sleep(50L);
                }
                Thread.sleep(2000L);
                test.removeTrace(current);
            }
            System.exit(0);
        }
        catch (Throwable f) {
            f.printStackTrace();
            System.exit(0);
        }
    }

    private TraceTester() {
    }

    private static class RandomPoints {
        protected Random m_rand = new Random();
        protected double m_xmin;
        protected double m_xrange;
        protected double m_ymin;
        protected double m_yrange;

        RandomPoints(int minx, int maxx, int miny, int maxy) {
            if (minx >= maxx) {
                throw new IllegalArgumentException("minx>=maxx!");
            }
            if (miny >= maxy) {
                throw new IllegalArgumentException("miny>=maxy!");
            }
            this.m_xmin = minx;
            this.m_xrange = maxx - minx;
            this.m_ymin = miny;
            this.m_yrange = maxy - miny;
        }

        public ITracePoint2D nextPoint() {
            return new TracePoint2D(this.m_rand.nextDouble() * this.m_xrange + this.m_xmin, this.m_rand.nextDouble() * this.m_yrange + this.m_ymin);
        }
    }

    static class HalfRandomPoints
    extends RandomPoints {
        private double m_oldx = 0.0;
        private double m_samexcount = 0.0;

        HalfRandomPoints(int minx, int maxx, int miny, int maxy) {
            super(minx, maxx, miny, maxy);
            this.m_oldx = (double)(maxx - minx) / 2.0;
        }

        @Override
        public ITracePoint2D nextPoint() {
            if (this.m_samexcount == 10.0) {
                this.m_samexcount = 0.0;
                this.m_oldx = this.m_rand.nextDouble() * this.m_xrange + this.m_xmin;
            }
            this.m_samexcount += 1.0;
            return new TracePoint2D(this.m_oldx, this.m_rand.nextDouble() * this.m_yrange + this.m_ymin);
        }
    }
}

