/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.controls.errorbarwizard;

import info.monitorenter.gui.chart.IErrorBarPainter;
import info.monitorenter.gui.chart.IPointPainterConfigurableUI;
import info.monitorenter.gui.chart.events.ErrorBarPainterActionSetSegmentColor;
import info.monitorenter.gui.chart.events.ErrorBarPainterActionSetSegmentPainter;
import info.monitorenter.gui.chart.pointpainters.APointPainter;
import info.monitorenter.gui.chart.pointpainters.PointPainterDisc;
import info.monitorenter.gui.chart.pointpainters.PointPainterLine;
import info.monitorenter.gui.util.ColorIcon;
import info.monitorenter.util.FileUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class ErrorBarPainterEditPanel
extends JPanel {
    private static final long serialVersionUID = -6564631494967160532L;
    private IErrorBarPainter m_errorBarPainter;

    public ErrorBarPainterEditPanel(IErrorBarPainter errorBarPainter) {
        this.m_errorBarPainter = errorBarPainter;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.gridy = 0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.add((Component)new SegmentChooserPanel(this.m_errorBarPainter.getSegmentStart()), gbc);
        gbc.gridy = 1;
        this.add((Component)new SegmentChooserPanel(this.m_errorBarPainter.getSegmentConnection()), gbc);
        gbc.gridy = 2;
        this.add((Component)new SegmentChooserPanel(this.m_errorBarPainter.getSegmentEnd()), gbc);
    }

    private class SegmentChooserPanel
    extends JPanel {
        private static final long serialVersionUID = 6645527616687209066L;
        protected IErrorBarPainter.ISegment m_segment;

        public SegmentChooserPanel(IErrorBarPainter.ISegment errorBarPainterSegement) {
            this.m_segment = errorBarPainterSegement;
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), errorBarPainterSegement.getName(), 1, 0));
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.gridx = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.gridy = 0;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridx = 0;
            final ErrorBarPainterActionSetSegmentColor colorAction = new ErrorBarPainterActionSetSegmentColor(errorBarPainterSegement, this, "color");
            JComboBox<ErrorBarPainterActionSetSegmentPainter> painterSelector = new JComboBox<ErrorBarPainterActionSetSegmentPainter>();
            IPointPainterConfigurableUI<?> usedPainter = errorBarPainterSegement.getPointPainter();
            APointPainter pointPainter = null;
            boolean painterSelected = false;
            ErrorBarPainterActionSetSegmentPainter action = new ErrorBarPainterActionSetSegmentPainter(errorBarPainterSegement, pointPainter, "Empty");
            painterSelector.addItem(action);
            if (usedPainter == null) {
                painterSelector.setSelectedItem(action);
            }
            pointPainter = new PointPainterLine();
            action = new ErrorBarPainterActionSetSegmentPainter(errorBarPainterSegement, pointPainter, FileUtil.cutExtension(pointPainter.getClass().getName()).getValue());
            painterSelector.addItem(action);
            if (usedPainter != null && pointPainter.getClass().equals(usedPainter.getClass())) {
                painterSelector.setSelectedItem(action);
                painterSelected = true;
            }
            pointPainter = new PointPainterDisc();
            action = new ErrorBarPainterActionSetSegmentPainter(errorBarPainterSegement, pointPainter, FileUtil.cutExtension(pointPainter.getClass().getName()).getValue());
            painterSelector.addItem(action);
            if (usedPainter != null && pointPainter.getClass().equals(usedPainter.getClass())) {
                painterSelector.setSelectedItem(action);
                painterSelected = true;
            }
            painterSelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComboBox source = (JComboBox)e.getSource();
                    Action currentAction = (Action)source.getSelectedItem();
                    currentAction.actionPerformed(e);
                    if (currentAction.getValue("Name").equals("Empty")) {
                        colorAction.setEnabled(false);
                    } else {
                        colorAction.setEnabled(true);
                    }
                }
            });
            this.add(painterSelector, gbc);
            ColorIcon colorIcon = new ColorIcon(errorBarPainterSegement.getColor());
            colorAction.putValue("SmallIcon", colorIcon);
            colorAction.setEnabled(painterSelected);
            JButton colorChooserButton = new JButton(colorAction);
            gbc.gridy = 1;
            errorBarPainterSegement.addPropertyChangeListener(errorBarPainterSegement.getPropertySegmentColor(), new ColorIconUpdater(colorIcon));
            this.add((Component)colorChooserButton, gbc);
        }

        final class ColorIconUpdater
        implements PropertyChangeListener {
            private ColorIcon m_adaptee;

            protected ColorIconUpdater(ColorIcon adaptee) {
                this.m_adaptee = adaptee;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String property = evt.getPropertyName();
                if (SegmentChooserPanel.this.m_segment.getPropertySegmentColor().equals(property)) {
                    this.m_adaptee.setColor((Color)evt.getNewValue());
                }
            }
        }
    }
}

