/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.axis;

import info.monitorenter.gui.chart.Chart2D;
import info.monitorenter.gui.chart.IAxis;
import info.monitorenter.gui.chart.IAxisLabelFormatter;
import info.monitorenter.gui.chart.IAxisScalePolicy;
import info.monitorenter.gui.chart.ITrace2D;
import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.LabeledValue;
import info.monitorenter.gui.chart.axis.AAxis;
import info.monitorenter.util.Range;
import info.monitorenter.util.math.MathUtil;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.List;

public class AxisInverse<T extends IAxisScalePolicy>
extends AAxis<T> {
    private static final long serialVersionUID = -1688970969107347292L;

    public AxisInverse() {
    }

    public AxisInverse(IAxisLabelFormatter formatter, T scalePolicy) {
        super(formatter, scalePolicy);
    }

    @Override
    protected AAxis.AChart2DDataAccessor createAccessor(Chart2D chart, int dimension, int position) {
        AAxis.AChart2DDataAccessor result;
        if (dimension == 1) {
            if ((position & 0x30) == 0) {
                throw new IllegalArgumentException("X axis only valid with top or bottom position.");
            }
            this.setAxisPosition(position);
            result = new XDataInverseAccessor(chart);
        } else if (dimension == 2) {
            if ((position & 0xC) == 0) {
                throw new IllegalArgumentException("Y axis only valid with left or right position.");
            }
            this.setAxisPosition(position);
            result = new YDataInverseAccessor(chart);
        } else {
            throw new IllegalArgumentException("Dimension has to be Chart2D.X or Chart2D.Y!");
        }
        return result;
    }

    @Override
    public IAxisScalePolicy setAxisScalePolicy(T axisScalePolicy) {
        return super.setAxisScalePolicy(new IAxisScalePolicy((IAxisScalePolicy)axisScalePolicy){
            final /* synthetic */ IAxisScalePolicy val$axisScalePolicy;
            {
                this.val$axisScalePolicy = iAxisScalePolicy;
            }

            public void initPaintIteration(IAxis axis) {
                this.val$axisScalePolicy.initPaintIteration(axis);
            }

            public List<LabeledValue> getScaleValues(Graphics g2d, IAxis axis) {
                List<LabeledValue> ret = this.val$axisScalePolicy.getScaleValues(g2d, axis);
                for (LabeledValue label : ret) {
                    label.setValue(1.0 - label.getValue());
                }
                return ret;
            }
        });
    }

    @Override
    public double getScaledValue(double absolute) {
        Range range = this.getRange();
        double scalerX = range.getExtent();
        double result = 1.0 - (absolute - range.getMin()) / scalerX;
        if (!MathUtil.isDouble(result)) {
            result = 0.0;
        }
        return result;
    }

    protected class YDataInverseAccessor
    extends AAxis.YDataAccessor {
        private static final long serialVersionUID = -1759763478911933057L;

        public YDataInverseAccessor(Chart2D chart) {
            super(chart);
        }

        @Override
        protected void scaleTrace(ITrace2D trace, Range range) {
            if (trace.isVisible()) {
                double scaler = range.getExtent();
                Iterator<ITracePoint2D> itPoints = trace.iterator();
                while (itPoints.hasNext()) {
                    ITracePoint2D point = itPoints.next();
                    double absolute = point.getY();
                    double result = 1.0 - (absolute - range.getMin()) / scaler;
                    if (!MathUtil.isDouble(result)) {
                        result = 0.0;
                    }
                    point.setScaledY(result);
                }
            }
        }

        @Override
        public double translatePxToValue(int pixel) {
            double result = 0.0;
            double px = this.m_chart.getYChartStart() - pixel;
            int rangeY = this.m_chart.getYChartStart() - this.m_chart.getYChartEnd();
            if (rangeY != 0) {
                double scaledY = 1.0 - px / (double)rangeY;
                Range valueRangeY = AxisInverse.this.getRange();
                result = scaledY * valueRangeY.getExtent() + valueRangeY.getMin();
            }
            return result;
        }
    }

    protected class XDataInverseAccessor
    extends AAxis.XDataAccessor {
        private static final long serialVersionUID = -7789192812199631543L;

        public XDataInverseAccessor(Chart2D chart) {
            super(chart);
        }

        @Override
        protected void scaleTrace(ITrace2D trace, Range range) {
            double scaler = range.getExtent();
            if (trace.isVisible()) {
                Iterator<ITracePoint2D> itPoints = trace.iterator();
                while (itPoints.hasNext()) {
                    ITracePoint2D point = itPoints.next();
                    double absolute = point.getX();
                    double result = 1.0 - (absolute - range.getMin()) / scaler;
                    if (!MathUtil.isDouble(result)) {
                        result = 0.0;
                    }
                    point.setScaledX(result);
                }
            }
        }

        @Override
        public double translatePxToValue(int pixel) {
            double result = 0.0;
            double px = pixel - this.m_chart.getXChartStart();
            int rangeX = this.m_chart.getXChartEnd() - this.m_chart.getXChartStart();
            if (rangeX != 0) {
                double scaledX = 1.0 - px / (double)rangeX;
                Range valueRangeX = AxisInverse.this.getRange();
                result = scaledX * valueRangeX.getExtent() + valueRangeX.getMin();
            }
            return result;
        }
    }
}

