/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util.geom;

import java.io.Serializable;

public class StrictBounds
implements Serializable,
Cloneable {
    private long x;
    private long y;
    private long width;
    private long height;
    private boolean locked;

    public StrictBounds() {
    }

    public StrictBounds(long x, long y, long width, long height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void add(StrictBounds bounds) {
        if (this.locked) {
            throw new IllegalStateException("This object is locked");
        }
        long x1 = Math.min(this.getX(), bounds.getX());
        long y1 = Math.min(this.getY(), bounds.getY());
        long x2 = Math.max(this.getX() + this.getWidth(), bounds.getX() + bounds.getWidth());
        long y2 = Math.max(this.getY() + this.getHeight(), bounds.getY() + bounds.getHeight());
        this.setRect(x1, y1, Math.max(0L, x2 - x1), Math.max(0L, y2 - y1));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Clone must always be supported.");
        }
    }

    public boolean contains(long x, long y) {
        if (x < this.x) {
            return false;
        }
        if (y < this.y) {
            return false;
        }
        if (x > this.x + this.width) {
            return false;
        }
        return y <= this.y + this.height;
    }

    public static boolean contains(StrictBounds rect1, StrictBounds rect2) {
        long x0 = rect1.getX();
        long y0 = rect1.getY();
        long x = rect2.getX();
        long y = rect2.getY();
        long w = rect2.getWidth();
        long h = rect2.getHeight();
        return x >= x0 && y >= y0 && x + w <= x0 + rect1.getWidth() && y + h <= y0 + rect1.getHeight();
    }

    public StrictBounds createIntersection(StrictBounds bounds) {
        long x1 = Math.max(this.getX(), bounds.getX());
        long y1 = Math.max(this.getY(), bounds.getY());
        long x2 = Math.min(this.getX() + this.getWidth(), bounds.getX() + bounds.getWidth());
        long y2 = Math.min(this.getY() + this.getHeight(), bounds.getY() + bounds.getHeight());
        return new StrictBounds(x1, y1, Math.max(0L, x2 - x1), Math.max(0L, y2 - y1));
    }

    public StrictBounds createUnion(StrictBounds bg) {
        long x = Math.min(this.getX(), bg.getX());
        long y = Math.min(this.getY(), bg.getY());
        long w = Math.max(this.getX() + this.getWidth(), bg.getX() + bg.getWidth()) - x;
        long h = Math.max(this.getY() + this.getHeight(), bg.getY() + bg.getHeight()) - y;
        return new StrictBounds(x, y, w, h);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StrictBounds)) {
            return false;
        }
        StrictBounds strictBounds = (StrictBounds)o;
        if (this.height != strictBounds.height) {
            return false;
        }
        if (this.width != strictBounds.width) {
            return false;
        }
        if (this.x != strictBounds.x) {
            return false;
        }
        return this.y == strictBounds.y;
    }

    public long getHeight() {
        return this.height;
    }

    public StrictBounds getLockedInstance() {
        if (this.locked) {
            return this;
        }
        StrictBounds retval = (StrictBounds)this.clone();
        retval.locked = true;
        return retval;
    }

    public StrictBounds getUnlockedInstance() {
        StrictBounds retval = (StrictBounds)this.clone();
        retval.locked = false;
        return retval;
    }

    public long getWidth() {
        return this.width;
    }

    public long getX() {
        return this.x;
    }

    public long getY() {
        return this.y;
    }

    public int hashCode() {
        int result = (int)(this.x ^ this.x >>> 32);
        result = 29 * result + (int)(this.y ^ this.y >>> 32);
        result = 29 * result + (int)(this.width ^ this.width >>> 32);
        result = 29 * result + (int)(this.height ^ this.height >>> 32);
        return result;
    }

    public static boolean intersects(StrictBounds rect1, StrictBounds rect2) {
        double x0 = rect1.getX();
        double y0 = rect1.getY();
        double x = rect2.getX();
        double width = rect2.getWidth();
        double y = rect2.getY();
        double height = rect2.getHeight();
        return x + width >= x0 && y + height >= y0 && x <= x0 + (double)rect1.getWidth() && y <= y0 + (double)rect1.getHeight();
    }

    public boolean isEmpty() {
        return this.width == 0L || this.height == 0L;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setRect(long x, long y, long w, long h) {
        if (this.locked) {
            throw new IllegalStateException("This object is locked");
        }
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public String toString() {
        return "org.jfree.report.util.geom.StrictBounds{" + "x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "}";
    }
}

