/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;

public class KeyedQueue
implements Serializable,
Cloneable {
    private LinkedList list;
    private HashMap table = new HashMap();
    private int limit;

    public KeyedQueue() {
        this(10);
    }

    public KeyedQueue(int limit) {
        this.list = new LinkedList();
        this.setLimit(limit);
    }

    public void clear() {
        this.table.clear();
        this.list.clear();
    }

    public Object clone() throws CloneNotSupportedException {
        KeyedQueue q = (KeyedQueue)super.clone();
        q.list = (LinkedList)this.list.clone();
        q.table = (HashMap)this.table.clone();
        return q;
    }

    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException("Key must not be null");
        }
        return this.table.get(key);
    }

    public int getLimit() {
        return this.limit;
    }

    public void put(Object key, Object ob) {
        if (key == null) {
            throw new NullPointerException("Key must not be null");
        }
        if (ob == null) {
            throw new NullPointerException("Value must not be null");
        }
        Object oldval = this.table.put(key, ob);
        if (oldval != null) {
            this.list.remove(oldval);
        }
        this.list.add(ob);
        if (this.getLimit() != 0 && this.list.size() > this.getLimit()) {
            this.removeLast();
        }
    }

    public void remove(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.table.remove(key);
        this.list.remove(key);
    }

    public void removeLast() {
        Object o = this.list.getLast();
        this.table.remove(o);
        this.list.remove(o);
    }

    public void setLimit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Limit must be at least 0.");
        }
        this.limit = limit;
    }
}

