/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.jfree.util.Log;

public class ImageComparator {
    private MessageDigest digestMD5;
    private MessageDigest digestSHA;

    public ImageComparator() {
        try {
            this.digestMD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.info((Object)"No MD5 algorithm available");
        }
        try {
            this.digestSHA = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Log.info((Object)"No SHA algorithm available");
        }
    }

    public Object createCompareData(byte[] image, boolean fast) {
        class Org_jfree_report_util_ImageComparator$1 {
            /* synthetic */ Org_jfree_report_util_ImageComparator$1() {
            }
        }
        if (!fast && this.digestMD5 != null && this.digestSHA != null) {
            byte[] dataMD5 = this.digestMD5.digest(image);
            byte[] dataSHA = this.digestSHA.digest(image);
            if (dataSHA != null && dataMD5 != null) {
                return new DigestImageCompareData(null, dataMD5, dataSHA);
            }
        }
        return new CompleteImageCompareData(null, image);
    }

    private static final class CompleteImageCompareData {
        private final byte[] image;

        /* synthetic */ CompleteImageCompareData(1 $0, byte[] $1) {
            this($1);
        }

        private CompleteImageCompareData(byte[] image) {
            this.image = image;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CompleteImageCompareData)) {
                return false;
            }
            CompleteImageCompareData data = (CompleteImageCompareData)o;
            return Arrays.equals(this.image, data.image);
        }

        public int hashCode() {
            return 0;
        }
    }

    private static final class DigestImageCompareData {
        private byte[] digestMD5Data;
        private byte[] digestSHAData;

        /* synthetic */ DigestImageCompareData(1 $0, byte[] $1, byte[] $2) {
            this($1, $2);
        }

        private DigestImageCompareData(byte[] digestMD5Data, byte[] digestSHAData) {
            if (digestMD5Data == null || digestSHAData == null) {
                throw new NullPointerException();
            }
            this.digestMD5Data = digestMD5Data;
            this.digestSHAData = digestSHAData;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DigestImageCompareData)) {
                return false;
            }
            DigestImageCompareData data = (DigestImageCompareData)o;
            if (!Arrays.equals(this.digestMD5Data, data.digestMD5Data)) {
                return false;
            }
            return Arrays.equals(this.digestSHAData, data.digestSHAData);
        }

        public int hashCode() {
            return 0;
        }
    }
}

