/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.simple.readhandlers;

import java.awt.Stroke;
import org.jfree.report.elementfactory.ShapeElementFactory;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.simple.readhandlers.AbstractElementReadHandler;
import org.jfree.report.util.StrokeUtility;
import org.jfree.xml.ParserUtil;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.SAXException;

public abstract class AbstractShapeElementReadHandler
extends AbstractElementReadHandler {
    private static final String SCALE_ATT = "scale";
    private static final String KEEP_ASPECT_RATIO_ATT = "keepAspectRatio";
    private static final String FILL_ATT = "fill";
    private static final String DRAW_ATT = "draw";

    private void handleColor(PropertyAttributes atts) {
        ShapeElementFactory elementFactory = (ShapeElementFactory)this.getElementFactory();
        elementFactory.setColor(ParserUtil.parseColor((String)atts.getValue("color"), null));
    }

    protected void handleDraw(PropertyAttributes atts) {
        String booleanValue = atts.getValue(DRAW_ATT);
        if (booleanValue != null) {
            ShapeElementFactory elementFactory = (ShapeElementFactory)this.getElementFactory();
            elementFactory.setShouldDraw(new Boolean(ParserUtil.parseBoolean((String)booleanValue, (boolean)false)));
        }
    }

    protected void handleFill(PropertyAttributes atts) {
        String booleanValue = atts.getValue(FILL_ATT);
        if (booleanValue != null) {
            ShapeElementFactory elementFactory = (ShapeElementFactory)this.getElementFactory();
            elementFactory.setShouldFill(new Boolean(ParserUtil.parseBoolean((String)booleanValue, (boolean)false)));
        }
    }

    protected void handleKeepAspectRatio(PropertyAttributes atts) {
        String booleanValue = atts.getValue(KEEP_ASPECT_RATIO_ATT);
        if (booleanValue != null) {
            ShapeElementFactory elementFactory = (ShapeElementFactory)this.getElementFactory();
            elementFactory.setKeepAspectRatio(new Boolean(ParserUtil.parseBoolean((String)booleanValue, (boolean)false)));
        }
    }

    protected void handleScale(PropertyAttributes atts) {
        String booleanValue = atts.getValue(SCALE_ATT);
        if (booleanValue != null) {
            ShapeElementFactory elementFactory = (ShapeElementFactory)this.getElementFactory();
            elementFactory.setScale(new Boolean(ParserUtil.parseBoolean((String)booleanValue, (boolean)false)));
        }
    }

    private void handleStroke(PropertyAttributes atts) {
        String strokeStyle = atts.getValue("stroke-style");
        float weight = ParserUtil.parseFloat((String)atts.getValue("weight"), (float)1.0f);
        Stroke stroke = null;
        if ("dashed".equalsIgnoreCase(strokeStyle)) {
            stroke = StrokeUtility.createStroke(1, weight);
        } else if ("dotted".equalsIgnoreCase(strokeStyle)) {
            stroke = StrokeUtility.createStroke(2, weight);
        } else if ("dot-dot-dash".equalsIgnoreCase(strokeStyle)) {
            stroke = StrokeUtility.createStroke(4, weight);
        } else if ("dot-dash".equalsIgnoreCase(strokeStyle)) {
            stroke = StrokeUtility.createStroke(3, weight);
        } else if ("solid".equalsIgnoreCase(strokeStyle)) {
            stroke = StrokeUtility.createStroke(0, weight);
        }
        if (stroke != null) {
            ShapeElementFactory elementFactory = (ShapeElementFactory)this.getElementFactory();
            elementFactory.setStroke(stroke);
        }
    }

    protected void startParsing(PropertyAttributes atts) throws SAXException, XmlReaderException {
        super.startParsing(atts);
        this.handleScale(atts);
        this.handleKeepAspectRatio(atts);
        this.handleFill(atts);
        this.handleDraw(atts);
        this.handleStroke(atts);
        this.handleColor(atts);
    }
}

