/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.parser.base;

import java.io.Serializable;
import org.jfree.report.ReportBuilderHints;
import org.jfree.report.modules.parser.base.CommentHintPath;
import org.jfree.report.modules.parser.base.PropertyAttributes;
import org.jfree.report.modules.parser.base.ReportParser;
import org.jfree.xml.parser.AbstractXmlReadHandler;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractPropertyXmlReadHandler
extends AbstractXmlReadHandler {
    public static final String OPEN_TAG_COMMENT = "xml-comment-open-tag";
    public static final String CLOSE_TAG_COMMENT = "xml-comment-close-tag";
    private String[] preOpenTagComments;
    private String[] preCloseTagComments;

    protected AbstractPropertyXmlReadHandler() {
    }

    protected final void defaultStoreComments(CommentHintPath hintPath) {
        int i;
        if (this.preOpenTagComments != null) {
            i = 0;
            while (i < this.preOpenTagComments.length) {
                this.getBuilderHints().addHintList(hintPath, OPEN_TAG_COMMENT, (Serializable)((Object)this.preOpenTagComments[i]), false);
                ++i;
            }
        }
        if (this.preCloseTagComments != null) {
            i = 0;
            while (i < this.preCloseTagComments.length) {
                this.getBuilderHints().addHintList(hintPath, CLOSE_TAG_COMMENT, (Serializable)((Object)this.preCloseTagComments[i]), false);
                ++i;
            }
        }
    }

    protected void doneParsing() throws SAXException, XmlReaderException {
        this.storeCloseComments();
        this.storeComments();
    }

    protected ReportBuilderHints getBuilderHints() {
        ReportParser parser = (ReportParser)this.getRootHandler();
        return parser.getParserHints();
    }

    protected XmlReadHandler getHandlerForChild(String tagName, PropertyAttributes attrs) throws XmlReaderException, SAXException {
        return null;
    }

    protected final XmlReadHandler getHandlerForChild(String tagName, Attributes atts) throws XmlReaderException, SAXException {
        return this.getHandlerForChild(tagName, new PropertyAttributes(this.getRootHandler(), atts));
    }

    public String[] getPreCloseTagComments() {
        return this.preCloseTagComments;
    }

    public String[] getPreOpenTagComments() {
        return this.preOpenTagComments;
    }

    protected void startParsing(PropertyAttributes attrs) throws SAXException, XmlReaderException {
        super.startParsing((Attributes)attrs);
    }

    protected final void startParsing(Attributes attrs) throws SAXException, XmlReaderException {
        this.preOpenTagComments = this.getRootHandler().getCommentHandler().getComments();
        this.startParsing(new PropertyAttributes(this.getRootHandler(), attrs));
    }

    protected final void storeCloseComments() {
        this.preCloseTagComments = this.getRootHandler().getCommentHandler().getComments();
    }

    protected abstract void storeComments() throws SAXException;
}

