/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.xls;

import java.awt.Color;
import java.awt.Stroke;
import java.util.HashMap;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.jfree.report.ElementAlignment;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.table.base.TableCellBackground;
import org.jfree.report.modules.output.table.xls.ExcelDataCellStyle;
import org.jfree.report.modules.output.table.xls.HSSFFontWrapper;
import org.jfree.report.modules.output.table.xls.util.ExcelColorSupport;
import org.jfree.report.modules.output.table.xls.util.ExcelFontFactory;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.StrokeUtility;
import org.jfree.util.Log;

public class HSSFCellStyleProducer {
    private HSSFCellStyle emptyCellStyle;
    private ExcelFontFactory fontFactory;
    private HSSFWorkbook workbook;
    private HSSFDataFormat dataFormat;
    private static final short WHITE_INDEX = new HSSFColor.WHITE().getIndex();
    private HashMap styleCache;
    private boolean warningDone;
    private boolean hardLimit;

    public HSSFCellStyleProducer(HSSFWorkbook workbook, boolean hardLimit) {
        if (workbook == null) {
            throw new NullPointerException();
        }
        this.styleCache = new HashMap();
        this.workbook = workbook;
        this.fontFactory = new ExcelFontFactory(workbook);
        this.dataFormat = workbook.createDataFormat();
        this.hardLimit = hardLimit;
    }

    private short convertAlignment(ElementAlignment e) {
        if (e == ElementAlignment.LEFT) {
            return 1;
        }
        if (e == ElementAlignment.RIGHT) {
            return 3;
        }
        if (e == ElementAlignment.CENTER) {
            return 2;
        }
        if (e == ElementAlignment.TOP) {
            return 0;
        }
        if (e == ElementAlignment.BOTTOM) {
            return 2;
        }
        if (e == ElementAlignment.MIDDLE) {
            return 1;
        }
        throw new IllegalArgumentException("Invalid alignment");
    }

    private ExcelDataCellStyle createCachedStyle(MetaElement element) {
        Color textColor = (Color)element.getProperty(ElementStyleSheet.PAINT);
        ElementAlignment horizontal = (ElementAlignment)element.getProperty(ElementStyleSheet.ALIGNMENT);
        ElementAlignment vertical = (ElementAlignment)element.getProperty(ElementStyleSheet.VALIGNMENT);
        String dataStyle = (String)element.getProperty(ElementStyleSheet.EXCEL_DATA_FORMAT_STRING);
        boolean wrapText = element.getProperty(ElementStyleSheet.EXCEL_WRAP_TEXT, Boolean.TRUE).equals(Boolean.TRUE);
        ExcelDataCellStyle style = new ExcelDataCellStyle(element.getFontDefinitionProperty(), textColor, horizontal, vertical, dataStyle, wrapText);
        return style;
    }

    public HSSFCellStyle createCellStyle(MetaElement element, TableCellBackground bg) {
        ExcelDataCellStyle style = element != null ? this.createCachedStyle(element) : null;
        HSSFCellStyleKey styleKey = new HSSFCellStyleKey(bg, style);
        if (this.styleCache.containsKey(styleKey)) {
            return (HSSFCellStyle)this.styleCache.get(styleKey);
        }
        if (this.styleCache.size() > 4000) {
            if (!this.warningDone) {
                Log.warn((Object)"HSSFCellStyleProducer has reached the limit of 4000 created styles.");
                this.warningDone = true;
            }
            if (this.hardLimit) {
                Log.warn((Object)"HSSFCellStyleProducer will not create more styles. New cells will not have any style.");
                return null;
            }
        }
        HSSFCellStyle hssfCellStyle = this.workbook.createCellStyle();
        hssfCellStyle.setFillForegroundColor(WHITE_INDEX);
        hssfCellStyle.setFillPattern((short)1);
        if (style != null) {
            HSSFFontWrapper wrapper = new HSSFFontWrapper(style.getFontDefinition(), style.getTextColor());
            hssfCellStyle.setAlignment(this.convertAlignment(style.getHorizontalAlignment()));
            hssfCellStyle.setVerticalAlignment(this.convertAlignment(style.getVerticalAlignment()));
            hssfCellStyle.setFont(this.fontFactory.getExcelFont(wrapper));
            hssfCellStyle.setWrapText(style.isWrapText());
            if (style.getDataStyle() != null) {
                hssfCellStyle.setDataFormat(this.dataFormat.getFormat(style.getDataStyle()));
            }
        }
        if (bg != null) {
            if (bg.getColorBottom() != null) {
                hssfCellStyle.setBorderBottom(this.translateStroke(bg.getBorderStrokeBottom()));
                hssfCellStyle.setBottomBorderColor(ExcelColorSupport.getNearestColor(bg.getColorBottom()));
            }
            if (bg.getColorTop() != null) {
                hssfCellStyle.setBorderTop(this.translateStroke(bg.getBorderStrokeTop()));
                hssfCellStyle.setTopBorderColor(ExcelColorSupport.getNearestColor(bg.getColorTop()));
            }
            if (bg.getColorLeft() != null) {
                hssfCellStyle.setBorderLeft(this.translateStroke(bg.getBorderStrokeLeft()));
                hssfCellStyle.setLeftBorderColor(ExcelColorSupport.getNearestColor(bg.getColorLeft()));
            }
            if (bg.getColorRight() != null) {
                hssfCellStyle.setBorderRight(this.translateStroke(bg.getBorderStrokeRight()));
                hssfCellStyle.setRightBorderColor(ExcelColorSupport.getNearestColor(bg.getColorRight()));
            }
            if (bg.getColor() != null) {
                hssfCellStyle.setFillForegroundColor(ExcelColorSupport.getNearestColor(bg.getColor()));
            }
        }
        this.styleCache.put(styleKey, hssfCellStyle);
        return hssfCellStyle;
    }

    public HSSFCellStyle getEmptyCellStyle() {
        if (this.emptyCellStyle == null) {
            this.emptyCellStyle = this.workbook.createCellStyle();
            this.emptyCellStyle.setFillForegroundColor(WHITE_INDEX);
            this.emptyCellStyle.setFillPattern((short)1);
        }
        return this.emptyCellStyle;
    }

    private short translateStroke(Stroke stroke) {
        float width = StrokeUtility.getStrokeWidth(stroke);
        int style = StrokeUtility.getStrokeType(stroke);
        if (style == 1) {
            if ((double)width < 1.5) {
                return 3;
            }
            return 8;
        }
        if (style == 4) {
            if ((double)width < 1.5) {
                return 11;
            }
            return 12;
        }
        if (style == 3) {
            if ((double)width < 1.5) {
                return 9;
            }
            return 10;
        }
        if (style == 2) {
            return 7;
        }
        if (width == 0.0f) {
            return 0;
        }
        if ((double)width < 0.5) {
            return 4;
        }
        if (width < 1.0f) {
            return 1;
        }
        if ((double)width < 1.5) {
            return 2;
        }
        if (width < 2.0f) {
            return 6;
        }
        return 5;
    }

    private static class HSSFCellStyleKey {
        private TableCellBackground background;
        private ExcelDataCellStyle cellStyle;

        public HSSFCellStyleKey(TableCellBackground background, ExcelDataCellStyle cellStyle) {
            this.background = background;
            this.cellStyle = cellStyle;
        }

        public boolean equals(Object o) {
            block15: {
                block14: {
                    boolean bl;
                    block13: {
                        HSSFCellStyleKey hssfCellStyleKey;
                        block12: {
                            block11: {
                                block10: {
                                    boolean bl2;
                                    block9: {
                                        block8: {
                                            if (this == o) {
                                                return true;
                                            }
                                            if (!(o instanceof HSSFCellStyleKey)) {
                                                return false;
                                            }
                                            hssfCellStyleKey = (HSSFCellStyleKey)o;
                                            if (this.background == null) break block8;
                                            bl2 = this.background.equals(hssfCellStyleKey.background) ^ true;
                                            break block9;
                                        }
                                        if (hssfCellStyleKey.background != null) break block10;
                                        bl2 = false;
                                    }
                                    if (!bl2) break block11;
                                }
                                return false;
                            }
                            if (this.cellStyle == null) break block12;
                            bl = this.cellStyle.equals(hssfCellStyleKey.cellStyle) ^ true;
                            break block13;
                        }
                        if (hssfCellStyleKey.cellStyle != null) break block14;
                        bl = false;
                    }
                    if (!bl) break block15;
                }
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = this.background != null ? this.background.hashCode() : 0;
            result = 29 * result + (this.cellStyle != null ? this.cellStyle.hashCode() : 0);
            return result;
        }
    }
}

