/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.xls;

import java.io.OutputStream;
import org.jfree.report.JFreeReport;
import org.jfree.report.ReportProcessingException;
import org.jfree.report.modules.output.meta.MetaBandProducer;
import org.jfree.report.modules.output.table.base.LayoutCreator;
import org.jfree.report.modules.output.table.base.TableCreator;
import org.jfree.report.modules.output.table.base.TableProcessor;
import org.jfree.report.modules.output.table.xls.ExcelContentCreator;
import org.jfree.report.modules.output.table.xls.ExcelMetaBandProducer;

public class ExcelProcessor
extends TableProcessor {
    public static final String ENHANCED_DATA_FORMAT_PROPERTY = "EnhancedDataFormat";
    private OutputStream outputStream;
    public static final String CONFIGURATION_PREFIX = "org.jfree.report.modules.output.table.xls";

    public ExcelProcessor(JFreeReport report) throws ReportProcessingException {
        super(report);
        this.init();
    }

    protected TableCreator createContentCreator() {
        LayoutCreator lc = this.getLayoutCreator();
        return new ExcelContentCreator(lc.getSheetLayoutCollection(), this.getOutputStream());
    }

    protected MetaBandProducer createMetaBandProducer() {
        return new ExcelMetaBandProducer(this.isDefineDataFormats(), this.isMaxLineHeightUsed());
    }

    protected String getExportDescription() {
        return "table/excel";
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    protected String getReportConfigurationPrefix() {
        return CONFIGURATION_PREFIX;
    }

    public boolean isDefineDataFormats() {
        return this.getReport().getReportConfiguration().getConfigProperty("org.jfree.report.modules.output.table.xls.EnhancedDataFormat", "true").equals("true");
    }

    public void setDefineDataFormats(boolean defineDataFormats) {
        this.getReport().getReportConfiguration().setConfigProperty("org.jfree.report.modules.output.table.xls.EnhancedDataFormat", String.valueOf(defineDataFormats));
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

