/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.table.html;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.jfree.report.DefaultImageReference;
import org.jfree.report.Element;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentCreationException;
import org.jfree.report.content.ContentFactory;
import org.jfree.report.content.EmptyContent;
import org.jfree.report.content.ImageContent;
import org.jfree.report.layout.DefaultLayoutSupport;
import org.jfree.report.modules.output.meta.MetaElement;
import org.jfree.report.modules.output.table.base.RawContent;
import org.jfree.report.modules.output.table.base.TableMetaBandProducer;
import org.jfree.report.modules.output.table.html.metaelements.HtmlImageMetaElement;
import org.jfree.report.modules.output.table.html.metaelements.HtmlTextMetaElement;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.ElementLayoutInformation;
import org.jfree.report.util.ImageUtils;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.ui.Drawable;
import org.jfree.util.Log;

public class HtmlMetaBandProducer
extends TableMetaBandProducer {
    private boolean useXHTML;
    private boolean useDeviceIndependentImageSizes;

    public HtmlMetaBandProducer(boolean useXHTML, boolean imageUnitIsPoint, boolean useMaxLineHeight) {
        super(new DefaultLayoutSupport(useMaxLineHeight));
        this.useXHTML = useXHTML;
        this.useDeviceIndependentImageSizes = imageUnitIsPoint;
    }

    protected MetaElement createDrawableCell(Element e, long x, long y) {
        DefaultImageReference imgref;
        Object o = e.getValue();
        if (!(o instanceof Drawable)) {
            return null;
        }
        Drawable drawable = (Drawable)o;
        StrictBounds rect = (StrictBounds)e.getStyle().getStyleProperty(ElementStyleSheet.BOUNDS);
        int imageWidth = (int)StrictGeomUtility.toExternalValue(rect.getWidth());
        int imageHeight = (int)StrictGeomUtility.toExternalValue(rect.getHeight());
        if (imageWidth == 0 && imageHeight == 0) {
            return null;
        }
        BufferedImage image = ImageUtils.createTransparentImage(imageWidth, imageHeight);
        Graphics2D g2 = (Graphics2D)((Image)image).getGraphics();
        drawable.draw(g2, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, imageWidth, imageHeight));
        g2.dispose();
        try {
            imgref = new DefaultImageReference(image);
        }
        catch (IOException iOException) {
            Log.warn((Object)"Unable to fully load a given image. (It should not happen here.)");
            return null;
        }
        ImageContent ic = new ImageContent(imgref, (StrictBounds)rect.clone());
        return new HtmlImageMetaElement(ic, this.createStyleForDrawableElement(e, x, y), this.useXHTML, this.useDeviceIndependentImageSizes);
    }

    protected MetaElement createImageCell(Element e, long x, long y) {
        ContentFactory contentFactory = this.getLayoutSupport().getContentFactory();
        if (!contentFactory.canHandleContent(e.getContentType())) {
            return null;
        }
        StrictBounds rect = (StrictBounds)e.getStyle().getStyleProperty(ElementStyleSheet.BOUNDS);
        if (rect.getWidth() == 0L || rect.getHeight() == 0L) {
            return null;
        }
        try {
            ElementLayoutInformation eli = new ElementLayoutInformation(rect);
            Content content = contentFactory.createContentForElement(e, eli, this.getLayoutSupport());
            if (EmptyContent.getDefaultEmptyContent().equals(content)) {
                return null;
            }
            ImageContent ic = (ImageContent)content;
            HtmlImageMetaElement me = new HtmlImageMetaElement(ic, this.createStyleForImageElement(e, x, y), this.useXHTML, this.useDeviceIndependentImageSizes);
            me.setName(e.getName());
            return me;
        }
        catch (ContentCreationException contentCreationException) {
            return null;
        }
    }

    protected MetaElement createTextCell(Element e, long x, long y) {
        Object o = e.getValue();
        if (!(o instanceof String)) {
            return null;
        }
        StrictBounds rect = (StrictBounds)e.getStyle().getStyleProperty(ElementStyleSheet.BOUNDS);
        HtmlTextMetaElement me = new HtmlTextMetaElement(new RawContent(rect, o), this.createStyleForTextElement(e, x, y), this.useXHTML);
        me.setName(e.getName());
        return me;
    }
}

