/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.support.pagelayout;

import java.io.Serializable;
import org.jfree.report.Band;
import org.jfree.report.Group;
import org.jfree.report.GroupFooter;
import org.jfree.report.GroupHeader;
import org.jfree.report.PageFooter;
import org.jfree.report.PageHeader;
import org.jfree.report.ReportDefinition;
import org.jfree.report.ReportFooter;
import org.jfree.report.Watermark;
import org.jfree.report.event.PageEventListener;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.event.ReportListener;
import org.jfree.report.function.FunctionProcessingException;
import org.jfree.report.modules.output.support.pagelayout.SimplePageLayoutWorker;
import org.jfree.report.style.BandStyleKeys;

public class SimplePageLayoutDelegate
implements PageEventListener,
ReportListener,
Cloneable,
Serializable {
    private SimplePageLayoutWorker worker;
    private final PageCarrier pageCarrier = new PageCarrier();
    private boolean lastPagebreak;
    private boolean groupFinishPending;
    public static final String HANDLE_PENDING_GROUP_FOOTER_KEY = "org.jfree.report.modules.output.support.pagelayout.HandlePendingGroupFooter";
    private boolean simplePageHeaderHandling;

    public SimplePageLayoutDelegate(SimplePageLayoutWorker worker) {
        this.setWorker(worker);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected int getCurrentEffectiveGroupIndex() {
        return this.worker.getCurrentEffectiveGroupIndex();
    }

    protected int getMaxPage() {
        return this.pageCarrier.getMaxPages();
    }

    public SimplePageLayoutWorker getWorker() {
        return this.worker;
    }

    public void groupFinished(ReportEvent event) {
        if (this.worker.isPageEnded()) {
            throw new IllegalStateException("AssertationFailed: Page is closed.");
        }
        try {
            this.setGroupFinishPending(true);
            int gidx = event.getState().getCurrentGroupIndex();
            Group g = event.getReport().getGroup(gidx);
            GroupFooter b = g.getFooter();
            if (this.worker.print(b, false, true)) {
                this.setGroupFinishPending(false);
                this.setCurrentEffectiveGroupIndex(this.getCurrentEffectiveGroupIndex() - 1);
            } else if (!event.getReport().getReportConfiguration().getConfigProperty(HANDLE_PENDING_GROUP_FOOTER_KEY, "true").equals("true")) {
                this.setGroupFinishPending(false);
                this.setCurrentEffectiveGroupIndex(this.getCurrentEffectiveGroupIndex() - 1);
            }
        }
        catch (FunctionProcessingException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionProcessingException("GroupFinished failed", e);
        }
    }

    public void groupStarted(ReportEvent event) {
        if (this.worker.isPageEnded()) {
            throw new IllegalStateException("AssertationFailed: Page is closed.");
        }
        try {
            this.setCurrentEffectiveGroupIndex(this.getCurrentEffectiveGroupIndex() + 1);
            int gidx = event.getState().getCurrentGroupIndex();
            Group g = event.getReport().getGroup(gidx);
            GroupHeader b = g.getHeader();
            this.worker.print(b, false, true);
        }
        catch (FunctionProcessingException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionProcessingException("GroupStarted failed", e);
        }
    }

    protected boolean isGroupFinishPending() {
        return this.groupFinishPending;
    }

    protected boolean isLastPagebreak() {
        return this.lastPagebreak;
    }

    private boolean isPageHeaderPrinting(Band b, ReportEvent event) {
        if (event.getState().getCurrentPage() == 1 && !b.getStyle().getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE)) {
            return false;
        }
        if (this.isSimplePageHeaderHandling()) {
            return true;
        }
        if (event.getState().getCurrentPage() == this.getMaxPage() && !b.getStyle().getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE)) {
            return false;
        }
        return !this.isLastPagebreak() || b.getStyle().getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE);
    }

    public boolean isSimplePageHeaderHandling() {
        return this.simplePageHeaderHandling;
    }

    public void itemsAdvanced(ReportEvent event) {
        if (this.worker.isPageEnded()) {
            throw new IllegalStateException("AssertationFailed: Page is closed.");
        }
        try {
            this.worker.print(event.getReport().getItemBand(), false, true);
        }
        catch (FunctionProcessingException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionProcessingException("ItemsAdvanced failed", e);
        }
    }

    public void itemsFinished(ReportEvent event) {
        if (this.worker.isPageEnded()) {
            throw new IllegalStateException("AssertationFailed: Page is closed.");
        }
        this.setCurrentEffectiveGroupIndex(this.getCurrentEffectiveGroupIndex() - 1);
    }

    public void itemsStarted(ReportEvent event) {
        if (this.worker.isPageEnded()) {
            throw new IllegalStateException("AssertationFailed: Page is closed.");
        }
        this.setCurrentEffectiveGroupIndex(this.getCurrentEffectiveGroupIndex() + 1);
        if (event.getState().getNumberOfRows() == 0) {
            try {
                this.worker.print(event.getReport().getNoDataBand(), false, true);
            }
            catch (FunctionProcessingException fe) {
                throw fe;
            }
            catch (Exception e) {
                throw new FunctionProcessingException("ItemsStarted failed", e);
            }
        }
    }

    public void pageCanceled(ReportEvent event) {
    }

    public void pageFinished(ReportEvent event) {
        try {
            this.worker.setReservedSpace(0L);
            ReportDefinition report = event.getReport();
            int groupsPrinted = this.getCurrentEffectiveGroupIndex();
            int gidx = groupsPrinted - 1;
            while (gidx >= 0) {
                Group g = report.getGroup(gidx);
                if (g.getFooter().getStyle().getBooleanStyleProperty(BandStyleKeys.REPEAT_HEADER)) {
                    this.worker.print(g.getFooter(), true, false);
                }
                --gidx;
            }
            PageFooter b = report.getPageFooter();
            if (event.getState().getCurrentPage() == 1) {
                if (b.getStyle().getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE)) {
                    this.worker.printBottom(b);
                }
            } else if (this.isLastPagebreak()) {
                if (b.getStyle().getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE)) {
                    this.worker.printBottom(b);
                }
            } else {
                this.worker.printBottom(b);
            }
        }
        catch (FunctionProcessingException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionProcessingException("PageFinished failed", e);
        }
    }

    public void pageRolledBack(ReportEvent event) {
    }

    public void pageStarted(ReportEvent event) {
        if (this.worker.isPageEnded()) {
            throw new IllegalStateException();
        }
        try {
            ReportDefinition report = event.getReport();
            Watermark watermark = report.getWatermark();
            if (this.worker.isWatermarkSupported() && this.isPageHeaderPrinting(watermark, event)) {
                this.worker.resetCursor();
                this.worker.printWatermark(watermark);
            }
            this.worker.resetCursor();
            PageHeader b = report.getPageHeader();
            if (this.isPageHeaderPrinting(b, event)) {
                this.worker.print(b, true, false);
            }
            int groupsPrinted = this.getCurrentEffectiveGroupIndex();
            if (this.isGroupFinishPending()) {
                ++groupsPrinted;
            }
            int gidx = 0;
            while (gidx < groupsPrinted) {
                Group g = report.getGroup(gidx);
                if (g.getHeader().getStyle().getBooleanStyleProperty(BandStyleKeys.REPEAT_HEADER)) {
                    this.worker.print(g.getHeader(), true, false);
                }
                ++gidx;
            }
            if (this.isGroupFinishPending()) {
                this.setCurrentEffectiveGroupIndex(this.getCurrentEffectiveGroupIndex() - 1);
                this.setGroupFinishPending(false);
            }
            this.worker.setTopPageContentPosition(this.worker.getCursorPosition());
        }
        catch (FunctionProcessingException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionProcessingException("PageStarted failed", e);
        }
    }

    public void reportDone(ReportEvent event) {
    }

    public void reportFinished(ReportEvent event) {
        if (this.worker.isPageEnded()) {
            throw new IllegalStateException("AssertationFailed: Page is closed.");
        }
        try {
            this.setCurrentEffectiveGroupIndex(this.getCurrentEffectiveGroupIndex() - 1);
            Object prepareRun = event.getState().getProperty("report.preparerun", Boolean.FALSE);
            if (prepareRun.equals(Boolean.TRUE)) {
                this.setMaxPage(event.getState().getCurrentPage());
            }
            this.setLastPagebreak(true);
            ReportFooter b = event.getReport().getReportFooter();
            this.worker.print(b, false, true);
        }
        catch (FunctionProcessingException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionProcessingException("ReportFinished failed", e);
        }
    }

    public void reportInitialized(ReportEvent event) {
    }

    public void reportStarted(ReportEvent event) {
        if (this.worker.isPageEnded()) {
            throw new IllegalStateException("Assertation: ReportStarted cannot have ended page");
        }
        try {
            this.setCurrentEffectiveGroupIndex(-1);
            this.worker.print(event.getReport().getReportHeader(), false, true);
        }
        catch (FunctionProcessingException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new FunctionProcessingException("ReportStarted failed", e);
        }
    }

    protected void setCurrentEffectiveGroupIndex(int currentEffectiveGroupIndex) {
        this.worker.setCurrentEffectiveGroupIndex(currentEffectiveGroupIndex);
    }

    protected void setGroupFinishPending(boolean groupFinishPending) {
        this.groupFinishPending = groupFinishPending;
    }

    protected void setLastPagebreak(boolean lastPagebreak) {
        this.lastPagebreak = lastPagebreak;
    }

    protected void setMaxPage(int maxPage) {
        this.pageCarrier.setMaxPages(maxPage);
    }

    public void setSimplePageHeaderHandling(boolean simplePageHeaderHandling) {
        this.simplePageHeaderHandling = simplePageHeaderHandling;
    }

    public void setWorker(SimplePageLayoutWorker worker) {
        if (worker == null) {
            throw new NullPointerException("The given worker is null.");
        }
        this.worker = worker;
    }

    private static final class PageCarrier
    implements Serializable {
        private int maxPages;

        public int getMaxPages() {
            return this.maxPages;
        }

        public void setMaxPages(int pages) {
            this.maxPages = pages;
        }
    }
}

