/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.plaintext;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class EncodingUtilities {
    private String encoding;
    private byte[] header;
    private byte[] space;
    private byte[] encodingHeader;

    public EncodingUtilities(String codepage) throws UnsupportedEncodingException {
        this.encoding = codepage;
        this.encodingHeader = " ".getBytes(codepage);
        byte[] spacesWithHeader = "  ".getBytes(codepage);
        int spaceCharLength = spacesWithHeader.length - this.encodingHeader.length;
        this.space = new byte[spaceCharLength];
        this.header = new byte[this.encodingHeader.length - spaceCharLength];
        System.arraycopy(spacesWithHeader, this.encodingHeader.length, this.space, 0, spaceCharLength);
        System.arraycopy(this.encodingHeader, 0, this.header, 0, this.header.length);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getEncodingHeader() {
        return this.header;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public byte[] getSpace() {
        return this.space;
    }

    public void writeEncodedText(String textString, OutputStream out) throws IOException {
        StringBuffer buffer = new StringBuffer(" ");
        buffer.append(textString);
        byte[] text = buffer.toString().getBytes(this.encoding);
        out.write(text, this.encodingHeader.length, text.length - this.encodingHeader.length);
    }

    public void writeEncodedText(char[] textString, OutputStream out) throws IOException {
        StringBuffer buffer = new StringBuffer(" ");
        buffer.append(textString);
        byte[] text = buffer.toString().getBytes(this.encoding);
        out.write(text, this.encodingHeader.length, text.length - this.encodingHeader.length);
    }
}

