/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.output.pageable.plaintext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jfree.report.modules.output.pageable.plaintext.DefaultPrinterSpecification;
import org.jfree.report.modules.output.pageable.plaintext.PrinterEncoding;
import org.jfree.report.modules.output.pageable.plaintext.PrinterSpecification;
import org.jfree.util.DefaultConfiguration;

public abstract class AbstractPrinterSpecificationLoader {
    public static final String ENCODING_PREFIX = "encoding.";
    public static final String ENCODING_NAME = ".name";
    public static final String ENCODING_CHARSET = ".charset";
    public static final String ENCODING_BYTES = ".bytes";
    public static final String PRINTER_PREFIX = "printer.";
    public static final String PRINTER_NAME = ".name";
    public static final String PRINTER_ENCODINGS = ".encodings";
    public static final String PRINTER_OPERATIONS = ".operations";

    protected DefaultPrinterSpecification createPrinterSpecification(String name, String displayName) {
        return new DefaultPrinterSpecification(name, displayName);
    }

    protected PrinterEncoding[] loadEncodings(DefaultConfiguration encodingConfig) {
        TreeSet<String> availableEncodingNames = new TreeSet<String>();
        Iterator it = encodingConfig.findPropertyKeys(ENCODING_PREFIX);
        while (it.hasNext()) {
            int endIndex;
            String name = (String)it.next();
            int beginIndex = name.indexOf(46);
            if (beginIndex == -1 || (endIndex = name.indexOf(46, beginIndex + 1)) == -1) continue;
            availableEncodingNames.add(name.substring(beginIndex + 1, endIndex));
        }
        Iterator encIt = availableEncodingNames.iterator();
        ArrayList<PrinterEncoding> encodings = new ArrayList<PrinterEncoding>();
        while (encIt.hasNext()) {
            String encodingKey = (String)encIt.next();
            String encodingName = encodingConfig.getProperty(ENCODING_PREFIX + encodingKey + ".name");
            String encodingCharset = encodingConfig.getProperty(ENCODING_PREFIX + encodingKey + ENCODING_CHARSET);
            String encodingBytes = encodingConfig.getProperty(ENCODING_PREFIX + encodingKey + ENCODING_BYTES);
            byte[] encodingCode = this.parseBytes(encodingBytes);
            PrinterEncoding encoding = new PrinterEncoding(encodingKey, encodingName, encodingCharset, encodingCode);
            encodings.add(encoding);
        }
        return encodings.toArray(new PrinterEncoding[encodings.size()]);
    }

    protected PrinterSpecification[] loadPrinters(DefaultConfiguration printerConfig, PrinterEncoding[] encodings) {
        HashMap<String, PrinterEncoding> encodingsByKey = new HashMap<String, PrinterEncoding>();
        int i = 0;
        while (i < encodings.length) {
            encodingsByKey.put(encodings[i].getInternalName(), encodings[i]);
            ++i;
        }
        TreeSet<String> availablePrinterNames = new TreeSet<String>();
        Iterator it = printerConfig.findPropertyKeys(PRINTER_PREFIX);
        while (it.hasNext()) {
            int endIndex;
            String name = (String)it.next();
            int beginIndex = name.indexOf(46);
            if (beginIndex == -1 || (endIndex = name.indexOf(46, beginIndex + 1)) == -1) continue;
            availablePrinterNames.add(name.substring(beginIndex + 1, endIndex));
        }
        PrinterSpecification[] retval = new PrinterSpecification[availablePrinterNames.size()];
        int index = 0;
        Iterator printerIt = availablePrinterNames.iterator();
        while (printerIt.hasNext()) {
            String printerKey = (String)printerIt.next();
            String printerName = printerConfig.getProperty(PRINTER_PREFIX + printerKey + ".name");
            String printerCharsets = printerConfig.getProperty(PRINTER_PREFIX + printerKey + PRINTER_ENCODINGS);
            String[] supportedCharsets = this.parseCSVString(printerCharsets);
            DefaultPrinterSpecification specification = this.createPrinterSpecification(printerKey, printerName);
            int i2 = 0;
            while (i2 < supportedCharsets.length) {
                PrinterEncoding encoding = (PrinterEncoding)encodingsByKey.get(supportedCharsets[i2]);
                if (encoding == null) {
                    throw new NullPointerException("PrinterEncoding '" + supportedCharsets[i2] + "' is not defined.");
                }
                specification.addEncoding(encoding);
                ++i2;
            }
            retval[index] = specification;
            ++index;
        }
        return retval;
    }

    private byte[] parseBytes(String encString) {
        StringTokenizer strtok = new StringTokenizer(encString, ",", false);
        ArrayList<String> tokens = new ArrayList<String>();
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            tokens.add(token);
        }
        byte[] retval = new byte[tokens.size()];
        int i = 0;
        while (i < tokens.size()) {
            retval[i] = Byte.parseByte((String)tokens.get(i));
            ++i;
        }
        return retval;
    }

    private String[] parseCSVString(String encString) {
        StringTokenizer strtok = new StringTokenizer(encString, ",", false);
        ArrayList<String> tokens = new ArrayList<String>();
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            tokens.add(token);
        }
        String[] retval = new String[tokens.size()];
        return tokens.toArray(retval);
    }
}

