/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.misc.survey;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.report.util.SerializerHelper;
import org.jfree.text.TextUtilities;
import org.jfree.ui.Drawable;
import org.jfree.ui.TextAnchor;
import org.jfree.util.BooleanList;
import org.jfree.util.BooleanUtilities;
import org.jfree.util.ShapeList;
import org.jfree.util.ShapeUtilities;

public class SurveyScale
implements Drawable,
Serializable {
    private static final Number[] EMPTY_VALUES = new Number[0];
    private int lowest;
    private int highest;
    private double lowerMargin = 0.1;
    private double upperMargin = 0.1;
    private BooleanList fillShapes;
    private Number[] values;
    private Number rangeLowerBound;
    private Number rangeUpperBound;
    private boolean drawBorder = false;
    private boolean drawTickMarks;
    private boolean drawScaleValues = false;
    private Font scaleValueFont;
    private transient Paint scaleValuePaint;
    private transient Paint rangePaint;
    private transient ShapeList shapes;
    private transient Paint fillPaint;
    private transient Stroke outlineStroke;
    private transient Shape defaultShape;
    private transient Paint tickMarkPaint;
    private transient Paint borderPaint;
    private int range;
    private double lowerBound;
    private double upperBound;

    public SurveyScale() {
        this(1, 5, EMPTY_VALUES);
    }

    public SurveyScale(int lowest, int highest, Number[] values) {
        this.lowest = lowest;
        this.highest = highest;
        this.values = values == null ? EMPTY_VALUES : (Number[])values.clone();
        this.drawTickMarks = true;
        this.tickMarkPaint = Color.gray;
        this.scaleValueFont = new Font("Serif", 2, 10);
        this.scaleValuePaint = Color.black;
        this.defaultShape = new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0);
        this.rangeLowerBound = null;
        this.rangeUpperBound = null;
        this.rangePaint = Color.lightGray;
        this.shapes = this.createShapeList();
        this.fillShapes = new BooleanList();
        this.fillShapes.setBoolean(0, Boolean.TRUE);
        this.fillPaint = Color.black;
        this.outlineStroke = new BasicStroke(0.5f);
        this.recompute();
    }

    protected ShapeList createShapeList() {
        ShapeList shapes = new ShapeList();
        shapes.setShape(0, (Shape)new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        shapes.setShape(1, ShapeUtilities.createDownTriangle((float)4.0f));
        shapes.setShape(2, ShapeUtilities.createUpTriangle((float)4.0f));
        shapes.setShape(3, ShapeUtilities.createDiamond((float)4.0f));
        shapes.setShape(4, (Shape)new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0));
        shapes.setShape(5, (Shape)new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0));
        return shapes;
    }

    public void draw(Graphics2D g2, Rectangle2D area) {
        if (this.isDrawBorder()) {
            this.drawBorder(g2, area);
        }
        this.drawRangeArea(area, g2);
        if (this.isDrawTickMarks()) {
            this.drawTickMarks(g2, area);
        }
        if (this.isDrawScaleValues()) {
            this.drawScaleValues(g2, area);
        }
        this.drawValues(g2, area);
    }

    protected void drawBorder(Graphics2D g2, Rectangle2D area) {
        g2.setStroke(this.getOutlineStroke());
        g2.setPaint(this.getBorderPaint());
        g2.draw(area);
    }

    protected void drawRangeArea(Rectangle2D area, Graphics2D g2) {
        Number rangeUpperBound = this.getRangeUpperBound();
        Number rangeLowerBound = this.getRangeLowerBound();
        if (rangeLowerBound == null || rangeUpperBound == null) {
            return;
        }
        double x0 = this.valueToJava2D(rangeLowerBound.doubleValue(), area);
        double x1 = this.valueToJava2D(rangeUpperBound.doubleValue(), area);
        Rectangle2D.Double rangeArea = new Rectangle2D.Double(x0, area.getY(), x1 - x0, area.getHeight());
        g2.setPaint(this.getRangePaint());
        g2.fill(rangeArea);
    }

    protected void drawScaleValues(Graphics2D g2, Rectangle2D area) {
        g2.setPaint(this.getScaleValuePaint());
        g2.setFont(this.getScaleValueFont());
        int highest = this.getHighest();
        int i = this.getLowest();
        while (i <= highest) {
            double x = this.valueToJava2D(i, area);
            double y = area.getCenterY();
            TextUtilities.drawAlignedString((String)String.valueOf(i), (Graphics2D)g2, (float)((float)x), (float)((float)y), (TextAnchor)TextAnchor.CENTER);
            ++i;
        }
    }

    protected void drawTickMarks(Graphics2D g2, Rectangle2D area) {
        g2.setPaint(this.getTickMarkPaint());
        g2.setStroke(new BasicStroke(0.1f));
        int highest = this.getHighest();
        int i = this.getLowest();
        while (i <= highest) {
            int j = 0;
            while (j < 10) {
                double xx = this.valueToJava2D((double)i + (double)j / 10.0, area);
                Line2D.Double mark = new Line2D.Double(xx, area.getCenterY() - 2.0, xx, area.getCenterY() + 2.0);
                g2.draw(mark);
                ++j;
            }
            ++i;
        }
        double xx = this.valueToJava2D(highest, area);
        Line2D.Double mark = new Line2D.Double(xx, area.getCenterY() - 2.0, xx, area.getCenterY() + 2.0);
        g2.draw(mark);
    }

    protected void drawValues(Graphics2D g2, Rectangle2D area) {
        Number[] values = this.getValues();
        if (values.length == 0) {
            return;
        }
        double y = area.getCenterY();
        Stroke outlineStroke = this.getOutlineStroke();
        Shape defaultShape = this.getDefaultShape();
        g2.setPaint(this.getFillPaint());
        int i = 0;
        while (i < values.length) {
            Number n = values[i];
            if (n != null) {
                double v = n.doubleValue();
                double x = this.valueToJava2D(v, area);
                Shape valueShape = this.getShape(i);
                if (valueShape == null) {
                    valueShape = defaultShape;
                }
                if (this.isShapeFilled(i)) {
                    g2.translate(x, y);
                    g2.fill(valueShape);
                    g2.translate(-x, -y);
                } else {
                    g2.setStroke(outlineStroke);
                    g2.translate(x, y);
                    g2.draw(valueShape);
                    g2.translate(-x, -y);
                }
            }
            ++i;
        }
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public Shape getDefaultShape() {
        return this.defaultShape;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public int getHighest() {
        return this.highest;
    }

    protected double getLowerBound() {
        return this.lowerBound;
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public int getLowest() {
        return this.lowest;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    protected int getRange() {
        return this.range;
    }

    public Number getRangeLowerBound() {
        return this.rangeLowerBound;
    }

    public Paint getRangePaint() {
        return this.rangePaint;
    }

    public Number getRangeUpperBound() {
        return this.rangeUpperBound;
    }

    public Font getScaleValueFont() {
        return this.scaleValueFont;
    }

    public Paint getScaleValuePaint() {
        return this.scaleValuePaint;
    }

    public Shape getShape(int index) {
        return this.shapes.getShape(index);
    }

    public Paint getTickMarkPaint() {
        return this.tickMarkPaint;
    }

    protected double getUpperBound() {
        return this.upperBound;
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public Number[] getValues() {
        return (Number[])this.values.clone();
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public boolean isDrawScaleValues() {
        return this.drawScaleValues;
    }

    public boolean isDrawTickMarks() {
        return this.drawTickMarks;
    }

    public boolean isShapeFilled(int index) {
        boolean result = false;
        Boolean b = this.fillShapes.getBoolean(index);
        if (b != null) {
            result = b;
        }
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        SerializerHelper helper = SerializerHelper.getInstance();
        this.scaleValuePaint = (Paint)helper.readObject(in);
        this.rangePaint = (Paint)helper.readObject(in);
        this.fillPaint = (Paint)helper.readObject(in);
        this.outlineStroke = (Stroke)helper.readObject(in);
        this.defaultShape = (Shape)helper.readObject(in);
        this.tickMarkPaint = (Paint)helper.readObject(in);
        this.borderPaint = (Paint)helper.readObject(in);
        this.shapes = new ShapeList();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            Shape s = (Shape)helper.readObject(in);
            this.shapes.setShape(i, s);
            ++i;
        }
    }

    protected void recompute() {
        this.range = Math.max(0, this.highest - this.lowest);
        this.lowerBound = (double)this.lowest - (double)this.range * this.lowerMargin;
        this.upperBound = (double)this.highest + (double)this.range * this.upperMargin;
    }

    public void setBorderPaint(Paint borderPaint) {
        if (borderPaint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.borderPaint = borderPaint;
    }

    public void setDefaultShape(Shape defaultShape) {
        if (defaultShape == null) {
            throw new NullPointerException("The default shape must not be null.");
        }
        this.defaultShape = defaultShape;
    }

    public void setDrawBorder(boolean flag) {
        this.drawBorder = flag;
    }

    public void setDrawScaleValues(boolean flag) {
        this.drawScaleValues = flag;
    }

    public void setDrawTickMarks(boolean flag) {
        this.drawTickMarks = flag;
    }

    public void setFillPaint(Paint fillPaint) {
        if (fillPaint == null) {
            throw new NullPointerException();
        }
        this.fillPaint = fillPaint;
    }

    public void setHighest(int highest) {
        this.highest = highest;
        this.recompute();
    }

    protected void setLowerBound(double lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setLowerMargin(double lowerMargin) {
        this.lowerMargin = lowerMargin;
    }

    public void setLowest(int lowest) {
        this.lowest = lowest;
        this.recompute();
    }

    public void setOutlineStroke(Stroke outlineStroke) {
        if (outlineStroke == null) {
            throw new NullPointerException();
        }
        this.outlineStroke = outlineStroke;
    }

    protected void setRange(int range) {
        this.range = range;
    }

    public void setRangeLowerBound(Number bound) {
        this.rangeLowerBound = bound;
    }

    public void setRangePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangePaint = paint;
    }

    public void setRangeUpperBound(Number bound) {
        this.rangeUpperBound = bound;
    }

    public void setScaleValueFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.scaleValueFont = font;
    }

    public void setScaleValuePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.scaleValuePaint = paint;
    }

    public void setShape(int index, Shape shape) {
        this.shapes.setShape(index, shape);
    }

    public void setShapeFilled(int index, boolean fill) {
        this.fillShapes.setBoolean(index, BooleanUtilities.valueOf((boolean)fill));
    }

    public void setTickMarkPaint(Paint tickMarkPaint) {
        if (tickMarkPaint == null) {
            throw new NullPointerException();
        }
        this.tickMarkPaint = tickMarkPaint;
    }

    protected void setUpperBound(double upperBound) {
        this.upperBound = upperBound;
    }

    public void setUpperMargin(double upperMargin) {
        this.upperMargin = upperMargin;
    }

    private double valueToJava2D(double value, Rectangle2D area) {
        double upperBound = this.getUpperBound();
        double lowerBound = this.getLowerBound();
        return area.getMinX() + (value - lowerBound) / (upperBound - lowerBound) * area.getWidth();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        SerializerHelper helper = SerializerHelper.getInstance();
        helper.writeObject(this.scaleValuePaint, out);
        helper.writeObject(this.rangePaint, out);
        helper.writeObject(this.fillPaint, out);
        helper.writeObject(this.outlineStroke, out);
        helper.writeObject(this.defaultShape, out);
        helper.writeObject(this.tickMarkPaint, out);
        helper.writeObject(this.borderPaint, out);
        int size = this.shapes.size();
        out.writeInt(size);
        int i = 0;
        while (i < size) {
            Shape s = this.shapes.getShape(i);
            helper.writeObject(s, out);
            ++i;
        }
    }
}

