/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.print;

import java.awt.Component;
import java.awt.print.PrinterJob;
import org.jfree.report.modules.gui.base.ExportTask;
import org.jfree.report.modules.gui.base.ReportPane;
import org.jfree.report.modules.gui.base.ReportProgressDialog;
import org.jfree.util.Log;

public class PrintExportTask
extends ExportTask {
    private ReportPane pageable;
    private ReportProgressDialog progressDialog;
    private String jobname;

    public PrintExportTask(ReportPane pageable, ReportProgressDialog progressDialog, String jobname) {
        if (pageable == null) {
            throw new NullPointerException("Pageable is null.");
        }
        this.progressDialog = progressDialog;
        this.pageable = pageable;
        this.jobname = jobname;
    }

    protected void dispose() {
        super.dispose();
        if (this.progressDialog != null) {
            this.pageable.removeRepaginationListener(this.progressDialog);
            this.progressDialog.dispose();
        }
    }

    protected void performExport() {
        PrinterJob pj = PrinterJob.getPrinterJob();
        if (this.jobname != null) {
            pj.setJobName(this.jobname);
        }
        pj.setPageable(this.pageable);
        if (pj.printDialog()) {
            if (this.progressDialog != null) {
                this.pageable.addRepaginationListener(this.progressDialog);
                this.progressDialog.setModal(false);
                ((Component)this.progressDialog).setVisible(true);
            }
            try {
                Object object = this.pageable.getReportLock();
                synchronized (object) {
                    this.pageable.setPrinting(true);
                }
                pj.print();
                object = this.pageable.getReportLock();
                synchronized (object) {
                    this.pageable.setPrinting(false);
                }
                this.setTaskDone();
            }
            catch (Exception e) {
                Log.error((Object)"Printing export failed", (Exception)e);
                this.setTaskFailed(e);
            }
        } else {
            this.setTaskAborted();
        }
        if (this.progressDialog != null) {
            ((Component)this.progressDialog).setVisible(false);
            this.pageable.removeRepaginationListener(this.progressDialog);
        }
    }
}

