/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.csv;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jfree.report.JFreeReport;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.modules.gui.base.AbstractExportPlugin;
import org.jfree.report.modules.gui.base.ExportTask;
import org.jfree.report.modules.gui.base.PreviewProxy;
import org.jfree.report.modules.gui.base.PreviewProxyBase;
import org.jfree.report.modules.gui.base.ReportProgressDialog;
import org.jfree.report.modules.gui.csv.CSVExportDialog;
import org.jfree.report.modules.gui.csv.CSVRawExportTask;
import org.jfree.report.modules.gui.csv.CSVTableExportTask;
import org.jfree.ui.RefineryUtilities;
import org.jfree.util.ResourceBundleSupport;

public class CSVExportPlugin
extends AbstractExportPlugin {
    private CSVExportDialog exportDialog;
    private final ResourceBundleSupport resources = new ResourceBundleSupport("org.jfree.report.modules.gui.csv.resources.csv-export-resources");
    public static final String BASE_RESOURCE_CLASS = "org.jfree.report.modules.gui.csv.resources.csv-export-resources";
    public static final String PROGRESS_DIALOG_ENABLE_KEY = "org.jfree.report.modules.gui.csv.ProgressDialogEnabled";

    protected ReportProgressDialog createProgressDialog() {
        ReportProgressDialog progressDialog = super.createProgressDialog();
        progressDialog.setDefaultCloseOperation(0);
        progressDialog.setTitle(this.resources.getString("cvs-export.progressdialog.title"));
        progressDialog.setMessage(this.resources.getString("cvs-export.progressdialog.message"));
        progressDialog.pack();
        RefineryUtilities.positionFrameRandomly((Window)progressDialog);
        return progressDialog;
    }

    public KeyStroke getAcceleratorKey() {
        return this.resources.getKeyStroke("action.export-to-csv.accelerator");
    }

    public String getDisplayName() {
        return this.resources.getString("action.export-to-csv.name");
    }

    protected synchronized CSVExportDialog getExportDialog() {
        if (this.exportDialog == null) {
            PreviewProxyBase base;
            Window w;
            PreviewProxy proxy = super.getProxy();
            this.exportDialog = proxy instanceof Frame ? new CSVExportDialog((Frame)((Object)proxy)) : (proxy instanceof Dialog ? new CSVExportDialog((Dialog)((Object)proxy)) : (proxy != null ? ((w = PreviewProxyBase.getWindowAncestor(base = proxy.getBase())) instanceof Frame ? new CSVExportDialog((Frame)w) : (w instanceof Dialog ? new CSVExportDialog((Dialog)w) : new CSVExportDialog())) : new CSVExportDialog()));
            this.exportDialog.pack();
        }
        return this.exportDialog;
    }

    public Icon getLargeIcon() {
        return this.getSkin().getIcon("action.export-to-csv.icon", true, true);
    }

    public Integer getMnemonicKey() {
        return this.resources.getMnemonic("action.export-to-csv.mnemonic");
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    public String getShortDescription() {
        return this.resources.getString("action.export-to-csv.description");
    }

    public Icon getSmallIcon() {
        return this.getSkin().getIcon("action.export-to-csv.small-icon", true, false);
    }

    public boolean isAddToToolbar() {
        return JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.csv.AddToToolbar", "false").equals("true");
    }

    public boolean isSeparated() {
        return JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("org.jfree.report.modules.gui.csv.Separated", "false").equals("true");
    }

    public boolean performExport(JFreeReport report) {
        ExportTask task;
        CSVExportDialog exportDialog = this.getExportDialog();
        boolean result = exportDialog.performQueryForExport(report);
        if (!result) {
            return this.handleExportResult(true);
        }
        if (exportDialog.isExportRawData()) {
            task = new CSVRawExportTask(exportDialog.getFilename(), exportDialog.getEncoding(), report);
        } else {
            ReportProgressDialog progressDialog = null;
            if (report.getReportConfiguration().getConfigProperty(PROGRESS_DIALOG_ENABLE_KEY, "false").equals("true")) {
                progressDialog = this.createProgressDialog();
            }
            task = new CSVTableExportTask(exportDialog.getFilename(), exportDialog.getEncoding(), progressDialog, report);
        }
        task.addExportTaskListener(new AbstractExportPlugin.DefaultExportTaskListener());
        this.delegateTask(task);
        return this.handleExportResult(task);
    }
}

