/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.gui.base.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jfree.report.modules.gui.base.Skin;
import org.jfree.report.modules.gui.base.SkinLoader;
import org.jfree.util.ResourceBundleSupport;

public class JStatusBar
extends JComponent {
    public static final int TYPE_ERROR = 3;
    public static final int TYPE_WARNING = 2;
    public static final int TYPE_INFORMATION = 1;
    public static final int TYPE_NONE = 0;
    private JLabel statusHolder;
    private JComponent otherComponents;
    private ResourceBundleSupport resources;
    private Skin skin;

    public JStatusBar() {
        this(Locale.getDefault());
    }

    public JStatusBar(Locale locale) {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getDefaults().getColor("controlShadow")));
        this.statusHolder = new JLabel(" ");
        this.statusHolder.setMinimumSize(new Dimension(0, 20));
        this.add((Component)this.statusHolder, "Center");
        this.otherComponents = new JPanel();
        this.add((Component)this.otherComponents, "East");
        this.resources = new ResourceBundleSupport(locale, "org.jfree.report.modules.gui.base.resources.jfreereport-resources");
        this.skin = SkinLoader.loadSkin();
    }

    public void clear() {
        this.setStatus(0, " ");
    }

    public JComponent getOtherComponents() {
        return this.otherComponents;
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    protected Skin getSkin() {
        return this.skin;
    }

    public void setStatus(int type, String text) {
        if (type == 3) {
            Icon res = this.getSkin().getIcon("statusbar.errorIcon", true, false);
            this.statusHolder.setIcon(res);
        } else if (type == 2) {
            Icon res = this.getSkin().getIcon("statusbar.warningIcon", true, false);
            this.statusHolder.setIcon(res);
        } else if (type == 1) {
            Icon res = this.getSkin().getIcon("statusbar.informationIcon", true, false);
            this.statusHolder.setIcon(res);
        } else {
            Icon res = this.getSkin().getIcon("statusbar.otherIcon", true, false);
            this.statusHolder.setIcon(res);
        }
        this.statusHolder.setText(text);
    }
}

