/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.layout;

import java.awt.geom.Dimension2D;
import org.jfree.report.Band;
import org.jfree.report.Element;
import org.jfree.report.layout.AbstractBandLayoutManager;
import org.jfree.report.layout.BandLayoutManager;
import org.jfree.report.layout.BandLayoutManagerUtil;
import org.jfree.report.layout.LayoutManagerCache;
import org.jfree.report.layout.LayoutSupport;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.util.ElementLayoutInformation;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictDimension;
import org.jfree.report.util.geom.StrictGeomUtility;

public class StackedLayoutManager
extends AbstractBandLayoutManager {
    protected StrictDimension computeMinimumSize(Element e, StrictDimension containerBounds, StrictDimension retval, LayoutSupport support, boolean allowCaching) {
        StrictDimension cretval;
        boolean isCacheable;
        LayoutManagerCache cache = support.getCache();
        boolean bl = isCacheable = cache.isCachable(e) && allowCaching;
        if (isCacheable && (cretval = cache.getMinSize(e.getObjectID())) != null) {
            return cretval;
        }
        if (e instanceof Band) {
            BandLayoutManager lm = BandLayoutManagerUtil.getLayoutManager(e);
            retval = lm.minimumLayoutSize((Band)e, containerBounds, containerBounds, support);
        } else {
            Dimension2D dim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MINIMUMSIZE);
            StrictDimension sDim = StrictGeomUtility.createDimension(dim.getWidth(), dim.getHeight());
            retval = AbstractBandLayoutManager.correctDimension(sDim, containerBounds, retval, support);
        }
        Dimension2D maxSizeElement = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MAXIMUMSIZE);
        StrictDimension maxSize = AbstractBandLayoutManager.correctDimension(StrictGeomUtility.createDimension(maxSizeElement.getWidth(), maxSizeElement.getHeight()), containerBounds, null, support);
        maxSize.setSize(Math.min(containerBounds.getWidth(), maxSize.getWidth()), Math.min(containerBounds.getHeight(), maxSize.getHeight()));
        if (e.getStyle().getBooleanStyleProperty(ElementStyleSheet.DYNAMIC_HEIGHT)) {
            retval = this.getElementContentBounds(retval, e, containerBounds, containerBounds, support);
        }
        retval.setSize(AbstractBandLayoutManager.alignUp(Math.min(retval.getWidth(), maxSize.getWidth()), support.getInternalHorizontalAlignmentBorder()), AbstractBandLayoutManager.alignUp(Math.min(retval.getHeight(), maxSize.getHeight()), support.getInternalVerticalAlignmentBorder()));
        if (retval.getWidth() < 0L || retval.getHeight() < 0L) {
            throw new IllegalStateException("Layouting failed, computeMinimumSize returned negative values.");
        }
        if (isCacheable) {
            cache.setMinSize(e, retval);
        }
        return retval;
    }

    protected StrictDimension computePreferredSize(Element e, StrictDimension containerBounds, StrictDimension retval, LayoutSupport support, boolean allowCaching) {
        StrictDimension cretval;
        boolean isCachable;
        LayoutManagerCache cache = support.getCache();
        boolean bl = isCachable = cache.isCachable(e) && allowCaching;
        if (isCachable && (cretval = cache.getPrefSize(e.getObjectID())) != null) {
            return cretval;
        }
        long alignedX = support.getInternalHorizontalAlignmentBorder();
        long alignedY = support.getInternalVerticalAlignmentBorder();
        if (e instanceof Band) {
            BandLayoutManager lm = BandLayoutManagerUtil.getLayoutManager(e);
            retval = lm.preferredLayoutSize((Band)e, containerBounds, containerBounds, support);
        } else {
            Dimension2D d = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.PREFERREDSIZE);
            if (d != null) {
                StrictDimension sDim = StrictGeomUtility.createDimension(d.getWidth(), d.getHeight());
                retval = AbstractBandLayoutManager.correctDimension(sDim, containerBounds, retval, support);
            } else {
                Dimension2D minDim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MINIMUMSIZE);
                StrictDimension sDim = StrictGeomUtility.createDimension(minDim.getWidth(), minDim.getHeight());
                retval = AbstractBandLayoutManager.correctDimension(sDim, containerBounds, retval, support);
            }
        }
        Dimension2D maxDim = (Dimension2D)e.getStyle().getStyleProperty(ElementStyleSheet.MAXIMUMSIZE);
        StrictDimension sMaxDim = StrictGeomUtility.createDimension(maxDim.getWidth(), maxDim.getHeight());
        StrictDimension maxSize = AbstractBandLayoutManager.correctDimension(sMaxDim, containerBounds, null, support);
        maxSize.setSize(Math.min(containerBounds.getWidth(), maxSize.getWidth()), Math.min(containerBounds.getHeight(), maxSize.getHeight()));
        if (e.getStyle().getBooleanStyleProperty(ElementStyleSheet.DYNAMIC_HEIGHT)) {
            retval = this.getElementContentBounds(retval, e, containerBounds, containerBounds, support);
        }
        retval.setSize(AbstractBandLayoutManager.alignUp(Math.min(retval.getWidth(), maxSize.getWidth()), alignedX), AbstractBandLayoutManager.alignUp(Math.min(retval.getHeight(), maxSize.getHeight()), alignedY));
        if (retval.getWidth() < 0L || retval.getHeight() < 0L) {
            throw new IllegalStateException("Layouting failed, computePreferredSize returned negative values." + e.getName());
        }
        if (isCachable) {
            cache.setPrefSize(e, retval);
        }
        return retval;
    }

    public void doLayout(Band b, LayoutSupport support) {
        if (support == null) {
            throw new NullPointerException("LayoutSupport is null.");
        }
        if (b == null) {
            throw new NullPointerException("Band is null.");
        }
        Element[] elements = b.getElementArray();
        StrictBounds parentBounds = BandLayoutManagerUtil.getBounds(b, null);
        if (parentBounds == null) {
            throw new IllegalStateException("Need the parent's bound set");
        }
        long intHAlign = support.getInternalHorizontalAlignmentBorder();
        long intVAlign = support.getInternalVerticalAlignmentBorder();
        StrictDimension parentDim = new StrictDimension(parentBounds.getWidth(), parentBounds.getHeight());
        long parentWidth = AbstractBandLayoutManager.alignUp(parentBounds.getWidth(), intHAlign);
        long yPosition = 0L;
        StrictDimension absDim = null;
        int i = 0;
        while (i < elements.length) {
            Element e = elements[i];
            if (e.isVisible()) {
                absDim = this.computePreferredSize(e, parentDim, absDim, support, true);
                long height = AbstractBandLayoutManager.alignUp(absDim.getHeight(), intVAlign);
                StrictBounds bounds = new StrictBounds(AbstractBandLayoutManager.alignDown(0L, intHAlign), AbstractBandLayoutManager.alignDown(yPosition, intVAlign), parentWidth, height);
                yPosition += height;
                BandLayoutManagerUtil.setBounds(e, bounds);
                if (e instanceof Band) {
                    BandLayoutManager lm = BandLayoutManagerUtil.getLayoutManager(e);
                    lm.doLayout((Band)e, support);
                }
            }
            ++i;
        }
    }

    public StrictDimension minimumLayoutSize(Band b, StrictDimension containerDims, StrictDimension maxUsableSize, LayoutSupport support) {
        StrictDimension cretval;
        if (support == null) {
            throw new NullPointerException("LayoutSupport is null.");
        }
        if (b == null) {
            throw new NullPointerException("Band is null.");
        }
        if (containerDims == null) {
            throw new NullPointerException("ContainerBounds is null.");
        }
        LayoutManagerCache cache = support.getCache();
        boolean isCacheable = cache.isCachable(b);
        if (isCacheable && (cretval = cache.getMinSize(b.getObjectID())) != null) {
            return cretval;
        }
        long hAlignBorder = support.getInternalHorizontalAlignmentBorder();
        long vAlignBorder = support.getInternalVerticalAlignmentBorder();
        ElementLayoutInformation eli = this.createLayoutInformationForMinimumSize(b, containerDims, containerDims, support);
        StrictDimension maxSize = eli.getMaximumSize();
        StrictDimension minSize = eli.getMinimumSize();
        long height = minSize.getHeight();
        long width = maxSize.getWidth();
        Element[] elements = b.getElementArray();
        StrictDimension tmpResult = new StrictDimension();
        int i = 0;
        while (i < elements.length) {
            Element e = elements[i];
            if (e.isVisible()) {
                boolean staticWidth = this.isElementStaticWidth(e);
                boolean staticHeight = this.isElementStaticHeight(e);
                if (staticWidth || staticHeight) {
                    StrictDimension size = this.computeMinimumSize(e, maxSize, tmpResult, support, staticHeight && staticWidth);
                    if (staticWidth) {
                        width = Math.max(size.getWidth(), width);
                    }
                    if (staticHeight) {
                        height += size.getHeight();
                    }
                }
            }
            ++i;
        }
        height = Math.max(height, minSize.getHeight());
        width = Math.max(width, minSize.getWidth());
        height = Math.min(height, maxSize.getHeight());
        width = Math.min(width, maxSize.getWidth());
        StrictDimension base = new StrictDimension(width, height);
        StrictDimension absDim = null;
        int i2 = 0;
        while (i2 < elements.length) {
            Element e = elements[i2];
            if (e.isVisible()) {
                boolean staticWidth = this.isElementStaticWidth(e);
                boolean staticHeight = this.isElementStaticHeight(e);
                if (!staticWidth || !staticHeight) {
                    absDim = AbstractBandLayoutManager.correctDimension(this.computeMinimumSize(e, base, absDim, support, true), base, absDim, support);
                    if (!staticWidth) {
                        width = Math.max(absDim.getWidth(), width);
                    }
                    if (!staticHeight) {
                        height += absDim.getHeight();
                    }
                }
            }
            ++i2;
        }
        height = Math.max(height, minSize.getHeight());
        width = Math.max(width, minSize.getWidth());
        height = Math.min(height, maxSize.getHeight());
        width = Math.min(width, maxSize.getWidth());
        StrictDimension fdim = new StrictDimension(AbstractBandLayoutManager.alignUp(width, hAlignBorder), AbstractBandLayoutManager.alignUp(height, vAlignBorder));
        if (isCacheable) {
            cache.setMinSize(b, fdim);
        }
        return fdim;
    }

    public StrictDimension preferredLayoutSize(Band b, StrictDimension containerDims, StrictDimension maxUsableSize, LayoutSupport support) {
        StrictDimension cretval;
        if (support == null) {
            throw new NullPointerException("LayoutSupport is null.");
        }
        if (b == null) {
            throw new NullPointerException("Band is null.");
        }
        if (containerDims == null) {
            throw new NullPointerException("ContainerBounds is null.");
        }
        LayoutManagerCache cache = support.getCache();
        boolean isCacheable = cache.isCachable(b);
        if (isCacheable && (cretval = cache.getMinSize(b.getObjectID())) != null) {
            return cretval;
        }
        long hAlignBorder = support.getInternalHorizontalAlignmentBorder();
        long vAlignBorder = support.getInternalVerticalAlignmentBorder();
        ElementLayoutInformation eli = this.createLayoutInformationForPreferredSize(b, containerDims, maxUsableSize, support);
        StrictDimension maxSize = eli.getMaximumSize();
        StrictDimension minSize = eli.getMinimumSize();
        StrictDimension prefSize = eli.getPreferredSize();
        if (prefSize != null) {
            if (isCacheable) {
                cache.setPrefSize(b, prefSize);
            }
            return prefSize;
        }
        long height = minSize.getHeight();
        long width = maxSize.getWidth();
        Element[] elements = b.getElementArray();
        StrictDimension tmpResult = new StrictDimension();
        int i = 0;
        while (i < elements.length) {
            Element e = elements[i];
            if (e.isVisible()) {
                boolean staticWidth = this.isElementStaticWidth(e);
                boolean staticHeight = this.isElementStaticHeight(e);
                if (staticWidth || staticHeight) {
                    StrictDimension size = this.computePreferredSize(e, maxSize, tmpResult, support, staticHeight && staticWidth);
                    if (staticWidth) {
                        width = Math.max(size.getWidth(), width);
                    }
                    if (staticHeight) {
                        height += size.getHeight();
                    }
                }
            }
            ++i;
        }
        height = Math.max(height, minSize.getHeight());
        width = Math.max(width, minSize.getWidth());
        height = Math.min(height, maxSize.getHeight());
        width = Math.min(width, maxSize.getWidth());
        StrictDimension base = new StrictDimension(width, height);
        StrictDimension absDim = null;
        int i2 = 0;
        while (i2 < elements.length) {
            Element e = elements[i2];
            if (e.isVisible()) {
                boolean staticWidth = this.isElementStaticWidth(e);
                boolean staticHeight = this.isElementStaticHeight(e);
                if (!staticWidth || !staticHeight) {
                    absDim = AbstractBandLayoutManager.correctDimension(this.computePreferredSize(e, base, absDim, support, true), base, absDim, support);
                    if (!staticWidth) {
                        width = Math.max(absDim.getWidth(), width);
                    }
                    if (!staticHeight) {
                        height += absDim.getHeight();
                    }
                }
            }
            ++i2;
        }
        height = Math.max(height, minSize.getHeight());
        width = Math.max(width, minSize.getWidth());
        height = Math.min(height, maxSize.getHeight());
        width = Math.min(width, maxSize.getWidth());
        StrictDimension fdim = new StrictDimension(AbstractBandLayoutManager.alignUp(width, hAlignBorder), AbstractBandLayoutManager.alignUp(height, vAlignBorder));
        if (isCacheable) {
            cache.setMinSize(b, fdim);
        }
        return fdim;
    }
}

