/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.Expression;
import org.jfree.report.function.FunctionUtilities;
import org.jfree.report.function.GroupCountFunction;

public class TotalGroupCountFunction
extends GroupCountFunction {
    private transient GroupCountStorage storage;
    private transient ArrayList results = new ArrayList();
    private transient int currentIndex;

    protected int getCount() {
        if (this.storage == null) {
            return 0;
        }
        return this.storage.getGroupCount();
    }

    public Expression getInstance() {
        TotalGroupCountFunction fn = (TotalGroupCountFunction)super.getInstance();
        fn.storage = null;
        fn.results = new ArrayList();
        return fn;
    }

    public void groupStarted(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup(this.getParentGroup(), event)) {
            if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
                this.storage = new GroupCountStorage();
                this.results.add(this.storage);
                if (this.getGroup() == null) {
                    this.setCount(this.getCount() + 1);
                }
            } else if (FunctionUtilities.isLayoutLevel(event)) {
                ++this.currentIndex;
                this.storage = (GroupCountStorage)this.results.get(this.currentIndex);
            }
        } else if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            super.groupStarted(event);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.results = new ArrayList();
    }

    public void reportInitialized(ReportEvent event) {
        this.currentIndex = -1;
        if (FunctionUtilities.isDefinedPrepareRunLevel(this, event)) {
            this.storage = null;
            this.results.clear();
            if (this.getParentGroup() == null) {
                this.storage = new GroupCountStorage();
                this.results.add(this.storage);
            }
        } else if (this.getParentGroup() == null) {
            this.storage = (GroupCountStorage)this.results.get(0);
        }
    }

    protected void setCount(int count) {
        if (this.storage == null) {
            this.storage = new GroupCountStorage();
        }
        this.storage.setGroupCount(count);
    }

    private static class GroupCountStorage
    implements Serializable {
        private int groupCount;

        public int getGroupCount() {
            return this.groupCount;
        }

        public void setGroupCount(int groupCount) {
            this.groupCount = groupCount;
        }
    }
}

