/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.jfree.report.DefaultImageReference;
import org.jfree.report.Element;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.event.LayoutEvent;
import org.jfree.report.event.LayoutListener;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.Expression;
import org.jfree.report.function.FunctionUtilities;
import org.jfree.report.layout.BandLayoutManagerUtil;
import org.jfree.report.util.ImageUtils;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.report.util.geom.StrictGeomUtility;
import org.jfree.util.Log;

public class PaintComponentFunction
extends AbstractFunction
implements LayoutListener,
Serializable {
    private transient Image image;
    private transient Frame peerSupply;
    private String element;
    private String field;
    private float scale;

    public PaintComponentFunction() {
        if (!PaintComponentFunction.isHeadless()) {
            this.peerSupply = new Frame();
            this.peerSupply.setLayout(new BorderLayout());
        }
        this.scale = 1.0f;
    }

    public String getElement() {
        return this.element;
    }

    public String getField() {
        return this.field;
    }

    public Expression getInstance() {
        PaintComponentFunction pc = (PaintComponentFunction)super.getInstance();
        if (!PaintComponentFunction.isHeadless()) {
            pc.peerSupply = new Frame();
            pc.peerSupply.setLayout(new BorderLayout());
        }
        return pc;
    }

    public float getScale() {
        return this.scale;
    }

    public Object getValue() {
        if (this.image == null) {
            return null;
        }
        try {
            DefaultImageReference ref = new DefaultImageReference(this.image);
            ref.setScale(1.0f / this.getScale(), 1.0f / this.getScale());
            return ref;
        }
        catch (IOException iOException) {
            Log.warn((Object)"Unable to fully load a given image. (It should not happen here.)");
            return null;
        }
    }

    protected static boolean isHeadless() {
        return JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty("java.awt.headless", "false").equals("true");
    }

    public void layoutComplete(LayoutEvent event) {
        if (PaintComponentFunction.isHeadless()) {
            return;
        }
        Object o = this.getDataRow().get(this.getField());
        if (!(o instanceof Component)) {
            this.image = null;
            return;
        }
        Element element = FunctionUtilities.findElement(event.getLayoutedBand(), this.getElement());
        if (element == null) {
            return;
        }
        float scale = this.getScale();
        StrictBounds strictBounds = BandLayoutManagerUtil.getBounds(element, null);
        if (strictBounds.getWidth() <= 0L || strictBounds.getHeight() <= 0L) {
            return;
        }
        Component comp = (Component)o;
        Dimension2D dim = StrictGeomUtility.createAWTDimension(strictBounds.getWidth(), strictBounds.getHeight());
        comp.setSize((int)dim.getWidth(), (int)dim.getHeight());
        if (comp instanceof Window) {
            Window window = (Window)comp;
            window.addNotify();
            BufferedImage bi = ImageUtils.createTransparentImage((int)((double)scale * dim.getWidth()), (int)((double)scale * dim.getHeight()));
            Graphics2D graph = bi.createGraphics();
            graph.setBackground(new Color(0, 0, 0, 0));
            graph.setTransform(AffineTransform.getScaleInstance(scale, scale));
            comp.paint(graph);
            graph.dispose();
            this.image = bi;
        } else {
            this.peerSupply.pack();
            this.peerSupply.add(comp, "Center");
            ((Component)this.peerSupply).setSize((int)dim.getWidth(), (int)dim.getHeight());
            BufferedImage bi = ImageUtils.createTransparentImage((int)((double)scale * dim.getWidth()), (int)((double)scale * dim.getHeight()));
            Graphics2D graph = bi.createGraphics();
            graph.setBackground(new Color(0, 0, 0, 0));
            graph.setTransform(AffineTransform.getScaleInstance(scale, scale));
            comp.paint(graph);
            graph.dispose();
            this.image = bi;
            this.peerSupply.remove(comp);
            this.peerSupply.dispose();
        }
    }

    public void outputComplete(LayoutEvent event) {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!PaintComponentFunction.isHeadless()) {
            this.peerSupply = new Frame();
            this.peerSupply.setLayout(new BorderLayout());
        }
    }

    public void setElement(String field) {
        if (field == null) {
            throw new NullPointerException();
        }
        this.element = field;
    }

    public void setField(String field) {
        if (field == null) {
            throw new NullPointerException();
        }
        this.field = field;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }
}

