/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.Serializable;
import java.util.HashMap;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.Expression;
import org.jfree.report.function.PageFunction;

public class PageTotalFunction
extends PageFunction {
    private PageStorage pageStorage;
    private HashMap groupPages = new HashMap();

    public Expression getInstance() {
        PageTotalFunction function = (PageTotalFunction)super.getInstance();
        function.groupPages = new HashMap();
        function.pageStorage = null;
        return function;
    }

    protected int getPage() {
        if (this.pageStorage == null) {
            return 0;
        }
        return this.pageStorage.getPage();
    }

    public void pageStarted(ReportEvent event) {
        if (event.getState().isPrepareRun() && event.getState().getLevel() < 0) {
            if (this.isGroupStarted()) {
                this.pageStorage = new PageStorage(this.getStartPage());
                this.setGroupStarted(false);
            } else {
                this.setPage(this.getPage() + this.getPageIncrement());
            }
            this.groupPages.put(new Integer(event.getState().getCurrentDisplayItem()), this.pageStorage);
        } else if (!event.getState().isPrepareRun()) {
            this.pageStorage = (PageStorage)this.groupPages.get(new Integer(event.getState().getCurrentDisplayItem()));
            if (this.pageStorage == null) {
                throw new IllegalStateException("No page-storage for the current state: " + event.getState().getCurrentDataItem());
            }
        }
    }

    public void reportInitialized(ReportEvent event) {
        if (this.pageStorage == null) {
            this.pageStorage = new PageStorage(this.getStartPage() - this.getPageIncrement());
        }
        this.setIgnoreNextGroup(true);
        this.setWaitForFooterPrinted(false);
    }

    protected void setPage(int page) {
        if (this.pageStorage != null) {
            this.pageStorage.setPage(page);
        }
    }

    private static class PageStorage
    implements Serializable {
        private int page;

        public PageStorage(int page) {
            this.page = page;
        }

        public int getPage() {
            return this.page;
        }

        public void setPage(int page) {
            this.page = page;
        }
    }
}

