/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.Serializable;
import java.math.BigDecimal;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.Expression;
import org.jfree.report.function.TotalGroupSumFunction;
import org.jfree.util.Log;

public class ItemPercentageFunction
extends AbstractFunction
implements Serializable {
    private TotalGroupSumFunction totalSumFunction = new TotalGroupSumFunction();
    private transient BigDecimal currentValue;
    private static final BigDecimal ZERO = new BigDecimal(0.0);
    private String group;
    private String field;

    public ItemPercentageFunction() {
        this.totalSumFunction.setName("total");
    }

    public Object clone() throws CloneNotSupportedException {
        ItemPercentageFunction clone = (ItemPercentageFunction)super.clone();
        clone.totalSumFunction = (TotalGroupSumFunction)this.totalSumFunction.clone();
        return clone;
    }

    public String getField() {
        return this.field;
    }

    public String getGroup() {
        return this.group;
    }

    public Expression getInstance() {
        ItemPercentageFunction function = (ItemPercentageFunction)super.getInstance();
        function.totalSumFunction = (TotalGroupSumFunction)this.totalSumFunction.getInstance();
        function.currentValue = ZERO;
        return function;
    }

    public Object getValue() {
        BigDecimal total = (BigDecimal)this.totalSumFunction.getValue();
        if (total.longValue() == 0L) {
            return null;
        }
        BigDecimal retval = this.currentValue.multiply(new BigDecimal(100.0)).divide(total, 4, 4);
        return retval;
    }

    public void groupStarted(ReportEvent event) {
        this.totalSumFunction.groupStarted(event);
        Object fieldValue = event.getDataRow().get(this.getField());
        if (fieldValue == null) {
            return;
        }
        try {
            Number n = (Number)fieldValue;
            this.currentValue = new BigDecimal(n.toString());
        }
        catch (Exception exception) {
            Log.error((Object)"ItemSumFunction.advanceItems(): problem adding number.");
        }
    }

    public void itemsAdvanced(ReportEvent event) {
        this.totalSumFunction.itemsAdvanced(event);
        Object fieldValue = event.getDataRow().get(this.getField());
        if (fieldValue == null) {
            return;
        }
        try {
            Number n = (Number)fieldValue;
            this.currentValue = new BigDecimal(n.toString());
        }
        catch (Exception exception) {
            Log.error((Object)"ItemSumFunction.advanceItems(): problem adding number.");
        }
    }

    public void reportInitialized(ReportEvent event) {
        this.totalSumFunction.reportInitialized(event);
        this.currentValue = ZERO;
    }

    public void setField(String field) {
        this.field = field;
        this.totalSumFunction.setField(field);
    }

    public void setGroup(String name) {
        this.group = name;
        this.totalSumFunction.setGroup(this.group);
    }
}

