/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.io.Serializable;
import org.jfree.report.Element;
import org.jfree.report.event.PageEventListener;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.FunctionUtilities;
import org.jfree.util.Log;

public class ElementVisibilitySwitchFunction
extends AbstractFunction
implements Serializable,
PageEventListener {
    private transient boolean trigger;
    private transient int count;
    private int togglecount;
    private boolean warned = false;
    private boolean pagebreak;
    private int numberOfElements = 1;
    private String element;
    private boolean initialState;
    private boolean newPageState;

    public String getElement() {
        return this.element;
    }

    public boolean getInitialState() {
        return this.initialState;
    }

    public boolean getInitialTriggerValue() {
        return this.initialState;
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public Object getValue() {
        if (this.trigger) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean isNewPageState() {
        return this.newPageState;
    }

    public void itemsAdvanced(ReportEvent event) {
        if (this.pagebreak) {
            this.trigger = this.getInitialState() ^ true;
            this.togglecount = this.getNumberOfElements();
            this.pagebreak = false;
        }
        this.triggerVisibleState(event);
    }

    public void itemsStarted(ReportEvent event) {
        this.pagebreak = false;
        this.trigger = this.getInitialState() ^ true;
        this.togglecount = this.getNumberOfElements();
        this.count = 0;
    }

    public void pageCanceled(ReportEvent event) {
    }

    public void pageFinished(ReportEvent event) {
    }

    public void pageRolledBack(ReportEvent event) {
        --this.count;
    }

    public void pageStarted(ReportEvent event) {
        this.pagebreak = false;
        this.trigger = this.newPageState;
        this.togglecount = this.getNumberOfElements();
        this.count = 0;
        this.triggerVisibleState(event);
    }

    public void setElement(String name) {
        this.element = name;
    }

    public void setInitialState(boolean initialState) {
        this.initialState = initialState;
    }

    public void setNewPageState(boolean newPageState) {
        this.newPageState = newPageState;
    }

    public void setNumberOfElements(int numberOfElements) {
        this.numberOfElements = numberOfElements;
    }

    private void triggerVisibleState(ReportEvent event) {
        if (this.count % this.togglecount == 0) {
            this.trigger ^= true;
        }
        ++this.count;
        if (this.element == null) {
            return;
        }
        Element[] e = FunctionUtilities.findAllElements(event.getReport().getItemBand(), this.getElement());
        if (e.length > 0) {
            int i = 0;
            while (i < e.length) {
                e[i].setVisible(this.trigger);
                ++i;
            }
        } else if (!this.warned) {
            Log.warn((Object)new Log.SimpleMessage("Element ", (Object)this.getElement(), (Object)"not defined in the item band"));
            this.warned = true;
        }
    }
}

