/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.jfree.report.DataRow;
import org.jfree.report.ResourceBundleFactory;
import org.jfree.report.function.AbstractExpression;

public class ConvertToDateExpression
extends AbstractExpression {
    private String field;
    private String format;
    private Locale locale;

    public String getField() {
        return this.field;
    }

    public String getFormat() {
        return this.format;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Object getValue() {
        DataRow dataRow = this.getDataRow();
        Object o = dataRow.get(this.field);
        if (o instanceof Date) {
            return o;
        }
        String formatString = this.getFormat();
        try {
            if (formatString == null || formatString.length() == 0) {
                DateFormat format = DateFormat.getDateInstance();
                return format.parse(String.valueOf(o));
            }
            SimpleDateFormat format = new SimpleDateFormat(formatString);
            if (this.locale != null) {
                format.setDateFormatSymbols(new DateFormatSymbols(this.getLocale()));
            } else {
                ResourceBundleFactory factory = this.getResourceBundleFactory();
                format.setDateFormatSymbols(new DateFormatSymbols(factory.getLocale()));
            }
            return format.parse(String.valueOf(o));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

