/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import org.jfree.report.Band;
import org.jfree.report.GroupFooter;
import org.jfree.report.GroupHeader;
import org.jfree.report.ItemBand;
import org.jfree.report.PageFooter;
import org.jfree.report.PageHeader;
import org.jfree.report.ReportFooter;
import org.jfree.report.ReportHeader;
import org.jfree.report.event.PageEventListener;
import org.jfree.report.event.ReportEvent;
import org.jfree.report.function.AbstractFunction;
import org.jfree.report.function.FunctionUtilities;

public abstract class AbstractElementFormatFunction
extends AbstractFunction
implements PageEventListener {
    private String element;

    protected AbstractElementFormatFunction() {
    }

    public String getElement() {
        return this.element;
    }

    public void groupFinished(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        GroupFooter b = FunctionUtilities.getCurrentGroup(event).getFooter();
        this.processRootBand(b);
    }

    public void groupStarted(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        GroupHeader b = FunctionUtilities.getCurrentGroup(event).getHeader();
        this.processRootBand(b);
    }

    public void itemsAdvanced(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        ItemBand b = event.getReport().getItemBand();
        this.processRootBand(b);
    }

    public void pageCanceled(ReportEvent event) {
    }

    public void pageFinished(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        PageFooter b = event.getReport().getPageFooter();
        this.processRootBand(b);
    }

    public void pageRolledBack(ReportEvent event) {
    }

    public void pageStarted(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        PageHeader b = event.getReport().getPageHeader();
        this.processRootBand(b);
    }

    protected abstract void processRootBand(Band var1);

    public void reportFinished(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        ReportFooter b = event.getReport().getReportFooter();
        this.processRootBand(b);
    }

    public void reportStarted(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        ReportHeader b = event.getReport().getReportHeader();
        this.processRootBand(b);
    }

    public void setElement(String name) {
        this.element = name;
    }
}

