/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.function;

import org.jfree.report.function.AbstractExpression;

public abstract class AbstractCompareExpression
extends AbstractExpression {
    public static final String EQUAL = "equal";
    public static final String NOT_EQUAL = "not-equal";
    public static final String LOWER = "lower";
    public static final String GREATER = "greater";
    public static final String LOWER_EQUAL = "lower-equal";
    public static final String GREATER_EQUAL = "greater-equal";
    private String compareMethod;
    private String field;

    protected abstract Comparable getComparable();

    public String getCompareMethod() {
        return this.compareMethod;
    }

    public String getField() {
        return this.field;
    }

    public Object getValue() {
        Object o = this.getDataRow().get(this.getField());
        if (!(o instanceof Comparable)) {
            return Boolean.FALSE;
        }
        try {
            Comparable c = (Comparable)o;
            Comparable comparable = this.getComparable();
            if (comparable == null) {
                return Boolean.FALSE;
            }
            int result = c.compareTo(comparable);
            String method = this.getCompareMethod();
            if (EQUAL.equals(method)) {
                if (result == 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (NOT_EQUAL.equals(method)) {
                if (result != 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (LOWER.equals(method)) {
                if (result < 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (LOWER_EQUAL.equals(method)) {
                if (result <= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (GREATER.equals(method)) {
                if (result > 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (GREATER_EQUAL.equals(method)) {
                if (result >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        catch (Exception exception) {}
        return Boolean.FALSE;
    }

    public void setCompareMethod(String compareMethod) {
        this.compareMethod = compareMethod;
    }

    public void setField(String field) {
        this.field = field;
    }
}

