/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.filter;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.Format;
import java.text.ParseException;
import org.jfree.report.filter.DataFilter;
import org.jfree.report.filter.DataSource;

public class FormatParser
implements DataFilter,
Serializable {
    private transient Format format;
    private DataSource datasource;
    private Object nullvalue;

    public Object clone() throws CloneNotSupportedException {
        FormatParser p = (FormatParser)super.clone();
        if (this.datasource != null) {
            p.datasource = (DataSource)this.datasource.clone();
        }
        if (this.format != null) {
            p.format = (Format)this.format.clone();
        }
        return p;
    }

    public DataSource getDataSource() {
        return this.datasource;
    }

    public Format getFormatter() {
        return this.format;
    }

    public Object getNullValue() {
        return this.nullvalue;
    }

    public Object getValue() {
        Format f = this.getFormatter();
        if (f == null) {
            return this.getNullValue();
        }
        DataSource ds = this.getDataSource();
        if (ds == null) {
            return this.getNullValue();
        }
        Object o = ds.getValue();
        if (o == null) {
            return this.getNullValue();
        }
        if (this.isValidOutput(o)) {
            return o;
        }
        try {
            return f.parseObject(String.valueOf(o));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    protected boolean isValidOutput(Object o) {
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public void setDataSource(DataSource ds) {
        if (ds == null) {
            throw new NullPointerException();
        }
        this.datasource = ds;
    }

    public void setFormatter(Format format) {
        if (format == null) {
            throw new NullPointerException();
        }
        this.format = format;
    }

    public void setNullValue(Object nullvalue) {
        this.nullvalue = nullvalue;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }
}

