/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.event;

import java.util.EventObject;
import org.jfree.report.DataRow;
import org.jfree.report.ReportDefinition;
import org.jfree.report.states.ReportState;

public class ReportEvent
extends EventObject {
    public static final int REPORT_INITIALIZED = 1;
    public static final int PAGE_STARTED = 2;
    public static final int REPORT_STARTED = 4;
    public static final int GROUP_STARTED = 8;
    public static final int ITEMS_STARTED = 16;
    public static final int ITEMS_ADVANCED = 32;
    public static final int ITEMS_FINISHED = 64;
    public static final int GROUP_FINISHED = 128;
    public static final int REPORT_FINISHED = 256;
    public static final int REPORT_DONE = 512;
    public static final int PAGE_FINISHED = 1024;
    public static final int PAGE_CANCELED = 2048;
    public static final int POST_GROUP_FOOTER = 4096;
    public static final int POST_GROUP_HEADER = 16384;
    public static final int PAGE_ROLLEDBACK = 32768;
    public static final int PREPARE_EVENT = 0x2000000;
    private int type;

    public ReportEvent(ReportState state, int type) {
        super(state);
        if (state == null) {
            throw new NullPointerException("ReportEvent(ReportState) : null not permitted.");
        }
        if (type <= 0) {
            throw new IllegalArgumentException("This is not a valid EventType: " + type);
        }
        this.type = type;
    }

    public DataRow getDataRow() {
        return this.getState().getDataRow();
    }

    public int getLevel() {
        return this.getState().getLevel();
    }

    public ReportDefinition getReport() {
        return this.getState().getReport();
    }

    public ReportState getState() {
        return (ReportState)this.getSource();
    }

    public int getType() {
        return this.type;
    }
}

