/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.elementfactory;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.report.Element;
import org.jfree.report.ElementAlignment;
import org.jfree.report.TextElement;
import org.jfree.report.elementfactory.TextElementFactory;
import org.jfree.report.filter.templates.StringFieldTemplate;
import org.jfree.report.style.ElementStyleSheet;
import org.jfree.report.style.FontDefinition;
import org.jfree.ui.FloatDimension;

public class TextFieldElementFactory
extends TextElementFactory {
    private String fieldname;
    private String nullString;

    public Element createElement() {
        if (this.getFieldname() == null) {
            throw new IllegalStateException("Fieldname is not set.");
        }
        StringFieldTemplate template = new StringFieldTemplate();
        template.setField(this.getFieldname());
        if (this.getNullString() != null) {
            template.setNullValue(this.getNullString());
        }
        TextElement element = new TextElement();
        this.applyElementName(element);
        element.setDataSource(template);
        ElementStyleSheet style = element.getStyle();
        this.applyStyle(style);
        return element;
    }

    public static TextElement createStringElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, ElementAlignment valign, FontDefinition font, String nullString, String field) {
        TextFieldElementFactory factory = new TextFieldElementFactory();
        factory.setAbsolutePosition(new Point2D.Double(bounds.getX(), bounds.getY()));
        factory.setMinimumSize((Dimension2D)new FloatDimension((float)bounds.getWidth(), (float)bounds.getHeight()));
        factory.setName(name);
        factory.setColor(paint);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valign);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(new Boolean(font.isBold()));
            factory.setItalic(new Boolean(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(null));
            factory.setUnderline(new Boolean(font.isUnderline()));
            factory.setStrikethrough(new Boolean(font.isStrikeThrough()));
            factory.setEmbedFont(new Boolean(font.isEmbeddedFont()));
        }
        factory.setFieldname(field);
        factory.setNullString(nullString);
        return (TextElement)factory.createElement();
    }

    public static TextElement createStringElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, FontDefinition font, String nullString, String field) {
        return TextFieldElementFactory.createStringElement(name, bounds, paint, alignment, ElementAlignment.TOP, font, nullString, field);
    }

    public String getFieldname() {
        return this.fieldname;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setFieldname(String fieldname) {
        this.fieldname = fieldname;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }
}

