/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.elementfactory;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.report.Element;
import org.jfree.report.ElementAlignment;
import org.jfree.report.TextElement;
import org.jfree.report.elementfactory.TextElementFactory;
import org.jfree.report.filter.templates.MessageFieldTemplate;
import org.jfree.report.style.FontDefinition;
import org.jfree.ui.FloatDimension;

public class MessageFieldElementFactory
extends TextElementFactory {
    private String formatString;
    private String nullString;

    public Element createElement() {
        MessageFieldTemplate messageFieldTemplate = new MessageFieldTemplate();
        messageFieldTemplate.setFormat(this.getFormatString());
        TextElement element = new TextElement();
        this.applyElementName(element);
        element.setDataSource(messageFieldTemplate);
        this.applyStyle(element.getStyle());
        return element;
    }

    public static TextElement createMessageElement(String name, Rectangle2D bounds, Color color, ElementAlignment alignment, ElementAlignment valign, FontDefinition font, String nullString, String formatString) {
        MessageFieldElementFactory factory = new MessageFieldElementFactory();
        factory.setAbsolutePosition(new Point2D.Double(bounds.getX(), bounds.getY()));
        factory.setMinimumSize((Dimension2D)new FloatDimension((float)bounds.getWidth(), (float)bounds.getHeight()));
        factory.setName(name);
        factory.setColor(color);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valign);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(new Boolean(font.isBold()));
            factory.setItalic(new Boolean(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(null));
            factory.setUnderline(new Boolean(font.isUnderline()));
            factory.setStrikethrough(new Boolean(font.isStrikeThrough()));
            factory.setEmbedFont(new Boolean(font.isEmbeddedFont()));
        }
        factory.setNullString(nullString);
        factory.setFormatString(formatString);
        return (TextElement)factory.createElement();
    }

    public static TextElement createMessageElement(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, FontDefinition font, String nullString, String format) {
        return MessageFieldElementFactory.createMessageElement(name, bounds, paint, alignment, ElementAlignment.TOP, font, nullString, format);
    }

    public String getFormatString() {
        return this.formatString;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }
}

