/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.content;

import java.util.ArrayList;
import org.jfree.report.JFreeReportBoot;
import org.jfree.report.content.ContentContainer;
import org.jfree.report.content.TextParagraph;
import org.jfree.report.layout.SizeCalculator;
import org.jfree.report.util.LineBreakIterator;
import org.jfree.report.util.geom.StrictBounds;
import org.jfree.util.Log;

public class TextContent
extends ContentContainer {
    public static final String DEBUG_TEXTCONTENT_KEY = "org.jfree.report.content.DebugTextContent";
    private final SizeCalculator sizeCalculator;

    public TextContent(String value, long lineHeight, StrictBounds bounds, SizeCalculator ot, String reservedLiteral, boolean trimTextContent) {
        super(bounds);
        this.sizeCalculator = ot;
        long x = bounds.getX();
        long y = bounds.getY();
        long w = bounds.getWidth();
        long h = bounds.getHeight();
        if (w <= 0L) {
            return;
        }
        LineBreakIterator iterator = new LineBreakIterator(value);
        if (!iterator.hasNext()) {
            return;
        }
        String firstLine = (String)iterator.next();
        if (iterator.hasNext()) {
            ArrayList<Object> paragraphs = new ArrayList<Object>();
            paragraphs.add(firstLine);
            while (iterator.hasNext()) {
                paragraphs.add(iterator.next());
            }
            long usedHeight = 0L;
            int i = 0;
            while (i < paragraphs.size()) {
                TextParagraph p = new TextParagraph(this.getSizeCalculator(), lineHeight, reservedLiteral, trimTextContent);
                p.setContent((String)paragraphs.get(i), x, y + usedHeight, w, h - usedHeight);
                usedHeight += p.getBounds().getHeight();
                this.addContentPart(p);
                ++i;
            }
            if (usedHeight == 0L && JFreeReportBoot.getInstance().getGlobalConfig().getConfigProperty(DEBUG_TEXTCONTENT_KEY, "false").equals("true")) {
                Log.warn((Object)"Empty TextContent created. This might indicate an invalid font size definition.");
            }
        } else {
            TextParagraph p = new TextParagraph(this.getSizeCalculator(), lineHeight, reservedLiteral, trimTextContent);
            p.setContent(firstLine, x, y, w, h);
            this.addContentPart(p);
        }
    }

    private SizeCalculator getSizeCalculator() {
        return this.sizeCalculator;
    }
}

