/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.content;

import org.jfree.report.Element;
import org.jfree.report.content.Content;
import org.jfree.report.content.ContentCreationException;
import org.jfree.report.content.ContentFactory;
import org.jfree.report.content.ContentFactoryModule;
import org.jfree.report.layout.LayoutSupport;
import org.jfree.report.util.ElementLayoutInformation;

public class DefaultContentFactory
implements ContentFactory {
    private ContentFactoryModule[] modules = new ContentFactoryModule[10];
    private int size = 0;

    public synchronized void addModule(ContentFactoryModule module) {
        if (module == null) {
            throw new NullPointerException();
        }
        this.ensureCapacity(this.size);
        this.modules[this.size] = module;
        ++this.size;
    }

    public synchronized boolean canHandleContent(String contentType) {
        int i = 0;
        while (i < this.size) {
            ContentFactoryModule cfm = this.modules[i];
            if (cfm.canHandleContent(contentType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized Content createContentForElement(Element e, ElementLayoutInformation bounds, LayoutSupport ot) throws ContentCreationException {
        if (bounds == null) {
            throw new NullPointerException("Bounds is null.");
        }
        if (ot == null) {
            throw new NullPointerException("LayoutSupport is null.");
        }
        if (e == null) {
            throw new NullPointerException("Element is null.");
        }
        String contentType = e.getContentType();
        int i = 0;
        while (i < this.modules.length) {
            ContentFactoryModule cfm = this.modules[i];
            if (cfm.canHandleContent(contentType)) {
                Content c = cfm.createContentForElement(e, bounds, ot);
                if (c == null) {
                    throw new NullPointerException("Content returned must never be null.");
                }
                return c;
            }
            ++i;
        }
        throw new ContentCreationException("No module registered for the content-type.");
    }

    private void ensureCapacity(int size) {
        if (this.modules.length <= size) {
            ContentFactoryModule[] newData = new ContentFactoryModule[Math.max(this.modules.length + 10, size + 1)];
            System.arraycopy(this.modules, 0, newData, 0, size);
            this.modules = newData;
        }
    }
}

