/*
 * Decompiled with CFR 0.152.
 */
package vmm.xm3d;

import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.SaveAndRestore;
import vmm.core.UserExhibit;
import vmm.core.Util;
import vmm.core.View;
import vmm.xm3d.MainForWebStart;
import vmm.xm3d.WindowXM;

public class MainXM3D {
    public static void main(String[] args) {
        String exhibitName = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].toLowerCase().startsWith("--locale=")) {
                String locale = args[i].substring(9).toLowerCase();
                if (locale.length() != 2) continue;
                I18n.setLocale(new Locale(locale));
                continue;
            }
            if (args[i].startsWith("-")) continue;
            exhibitName = args[i];
        }
        Exhibit exhibit = null;
        View view = null;
        if (exhibitName != null) {
            try {
                if (exhibitName.endsWith(".xml")) {
                    ClassLoader cl = MainForWebStart.class.getClassLoader();
                    URL url = cl.getResource(exhibitName);
                    if (url == null) {
                        throw new Exception("Can't find resource file.");
                    }
                    InputStream in = url.openStream();
                    exhibit = SaveAndRestore.readExhibitFromXML(in, "Settings File");
                    view = exhibit.getViews().get(0);
                } else {
                    exhibit = (Exhibit)Class.forName(exhibitName).newInstance();
                    if (exhibit instanceof UserExhibit) {
                        view = ((UserExhibit)((Object)exhibit)).getUserExhibitSupport().defaults();
                        if (view == null) {
                            throw new Exception("Error while creating user exhibits with default settings");
                        }
                    } else {
                        view = exhibit.getDefaultView();
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Could not load specified exhibit, \"" + exhibitName + "\".");
                e.printStackTrace();
                exhibit = null;
                view = null;
            }
        }
        if (Util.isMacOS()) {
            try {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", "3D-XPlorMath-J");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        WindowXM window = new WindowXM();
        if (exhibit != null) {
            window.getMenus().install(view, exhibit);
        }
        window.setVisible(true);
    }
}

