/*
 * Decompiled with CFR 0.152.
 */
package vmm.xm3d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import vmm.core.I18n;

public class HTMLDocWindow
extends JFrame {
    private JEditorPane editPane;
    private ArrayList<Object> history = new ArrayList();
    private int currentHistoryIndex = -1;
    private JButton backButton;
    private JButton forwardButton;
    private JButton closeButton;

    public HTMLDocWindow() {
        super(I18n.tr("3dxm.HTMLDocWindow.title"));
        this.setDefaultCloseOperation(1);
        this.editPane = new JEditorPane();
        this.editPane.setEditable(false);
        this.editPane.setMargin(new Insets(15, 15, 10, 5));
        this.editPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        HTMLDocWindow.this.editPane.setPage(evt.getURL());
                    }
                    catch (Exception e) {
                        HTMLDocWindow.this.editPane.setContentType("text/plain");
                        HTMLDocWindow.this.editPane.setText(I18n.tr("3dxm.HTMLDocWindow.loadError") + "\n");
                    }
                }
            }
        });
        this.backButton = new JButton(I18n.tr("3dxm.HTMLDocWindow.Back"));
        this.forwardButton = new JButton(I18n.tr("3dxm.HTMLDocWindow.Forward"));
        this.closeButton = new JButton(I18n.tr("3dxm.HTMLDocWindow.Close"));
        JPanel buttonBar = new JPanel();
        buttonBar.setLayout(new FlowLayout(2));
        buttonBar.add(this.backButton);
        buttonBar.add(this.forwardButton);
        buttonBar.add(this.closeButton);
        this.backButton.setEnabled(false);
        this.forwardButton.setEnabled(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HTMLDocWindow.this.setVisible(false);
                HTMLDocWindow.this.history.clear();
                HTMLDocWindow.this.currentHistoryIndex = -1;
            }
        });
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HTMLDocWindow.this.historyBack();
            }
        });
        this.forwardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HTMLDocWindow.this.historyForward();
            }
        });
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout(3, 3));
        content.setBackground(Color.GRAY);
        content.add((Component)new JScrollPane(this.editPane), "Center");
        content.add((Component)buttonBar, "South");
        this.setContentPane(content);
        HTMLEditorKit kit = (HTMLEditorKit)this.editPane.getEditorKitForContentType("text/html");
        kit.getStyleSheet().addRule("body { font-size: 16pt }");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 620) / 2, 100, 650, 500);
    }

    public HTMLDocWindow(String initialFile) {
        this();
        if (initialFile != null) {
            this.showFile(initialFile);
        } else {
            this.setVisible(true);
        }
    }

    public HTMLDocWindow(URL initialURL) {
        this();
        if (initialURL != null) {
            this.showURL(initialURL);
        } else {
            this.setVisible(true);
        }
    }

    public void showURL(URL url) {
        this.historyAdd(url);
        try {
            this.editPane.setPage(url);
        }
        catch (Exception e) {
            this.editPane.setContentType("text/plain");
            this.editPane.setText(I18n.tr("3dxm.HTMLDocWindow.loadError") + "\n");
        }
        this.setVisible(true);
    }

    public void showFile(String file) {
        this.historyAdd(file);
        try {
            URL fileURL = this.getClass().getClassLoader().getResource(file);
            if (fileURL == null) {
                throw new Exception();
            }
            this.editPane.setPage(fileURL);
        }
        catch (Exception e) {
            this.editPane.setContentType("text/plain");
            this.editPane.setText(I18n.tr("3dxm.HTMLDocWindow.loadError") + "\n");
        }
        this.setVisible(true);
    }

    private void historyBack() {
        if (this.currentHistoryIndex > 0) {
            --this.currentHistoryIndex;
            this.showFromHistory();
        }
    }

    private void historyForward() {
        if (this.currentHistoryIndex >= 0 && this.currentHistoryIndex < this.history.size() - 1) {
            ++this.currentHistoryIndex;
            this.showFromHistory();
        }
    }

    private void showFromHistory() {
        Object location = this.history.get(this.currentHistoryIndex);
        try {
            URL newLocation = location instanceof String ? this.getClass().getClassLoader().getResource((String)location) : (URL)location;
            this.editPane.setPage(newLocation);
        }
        catch (Exception e) {
            this.editPane.setContentType("text/plain");
            this.editPane.setText(I18n.tr("3dxm.HTMLDocWindow.loadError") + "\n");
        }
        this.backButton.setEnabled(this.currentHistoryIndex > 0);
        this.forwardButton.setEnabled(this.currentHistoryIndex < this.history.size() - 1);
    }

    private void historyAdd(Object location) {
        if (this.currentHistoryIndex == -1) {
            this.history.add(location);
            this.currentHistoryIndex = 0;
        } else {
            if (location.equals(this.history.get(this.currentHistoryIndex))) {
                return;
            }
            while (this.history.size() > this.currentHistoryIndex + 1) {
                this.history.remove(this.history.size() - 1);
            }
            this.history.add(location);
            this.currentHistoryIndex = this.history.size() - 1;
        }
        this.backButton.setEnabled(this.currentHistoryIndex > 0);
        this.forwardButton.setEnabled(this.currentHistoryIndex < this.history.size() - 1);
    }
}

