/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.Complex;
import vmm.core.IntegerParam;
import vmm.core.RealParamAnimateable;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class Scherk_Weierstrass
extends WeierstrassMinimalSurface {
    private IntegerParam exponent = new IntegerParam("vmm.surface.parametric.Scherk_Weierstrass.MainEx", 2);
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.Scherk_Weierstrass.aa", 0.0, 0.0, 0.9);
    private int ex;
    private int j0;
    private double AA;
    private double r1;
    private double rex;
    private double re_e;
    private double mob;

    public Scherk_Weierstrass() {
        this.setFramesForMorphing(12);
        this.afp.reset(0.0, 0.0, 0.0);
        this.addParameter(this.aa);
        this.addParameter(this.exponent);
        this.setDefaultViewpoint(new Vector3D(-7.0, 17.0, 47.0));
        this.setDefaultWindow(-4.0, 4.0, -3.0, 3.0);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-3.5);
        this.umax.reset(0.0);
        this.vmin.reset(-1.5707963267948966);
        this.vmax.reset(1.5707963267948966);
        this.wantsToSeeDomain = false;
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.removeParameter(this.umax);
        this.removeParameter(this.vmax);
        this.removeParameter(this.vmin);
        this.umin.setMaximumValueForInput(-0.05);
        this.iFirstInHelper = false;
        this.multipleCopyOptions = new int[]{2};
        this.canShowConjugateSurface = true;
    }

    @Override
    protected void createData() {
        block16: {
            int e;
            super.createData();
            this.data.discardGridTransforms();
            if (this.inAssociateMorph || !this.flag0 && !this.flag05 || this.wantsToSeeDomain) break block16;
            GridTransformMatrix[] trList = new GridTransformMatrix[this.ex * 8];
            trList[0] = new GridTransformMatrix();
            if (this.flag0) {
                trList[1] = new GridTransformMatrix().scale(1.0, -1.0, 1.0);
                this.data.addGridTransform(trList[1]);
            } else if (this.flag05) {
                trList[1] = new GridTransformMatrix().scale(-1.0, 1.0, -1.0).reverse();
                this.data.addGridTransform(trList[1]);
            }
            for (e = 1; e < this.ex; ++e) {
                trList[2 * e] = new GridTransformMatrix(trList[2 * e - 2]).rotateZ(360.0 / (double)this.ex);
                this.data.addGridTransform(trList[2 * e]);
                trList[2 * e + 1] = new GridTransformMatrix(trList[2 * e - 1]).rotateZ(360.0 / (double)this.ex);
                this.data.addGridTransform(trList[2 * e + 1]);
            }
            if (this.flag0) {
                for (e = 0; e < 2 * this.ex; ++e) {
                    trList[2 * this.ex + e] = new GridTransformMatrix(trList[e]).scale(1.0, 1.0, -1.0);
                    this.data.addGridTransform(trList[2 * this.ex + e]);
                }
            }
            if (this.flag05) {
                for (e = 0; e < 2 * this.ex; ++e) {
                    trList[2 * this.ex + e] = new GridTransformMatrix(trList[e]).scale(-1.0, -1.0, 1.0).reverse().translate(this.halfPeriod.im().times(2.0));
                    this.data.addGridTransform(trList[2 * this.ex + e]);
                }
            }
            if (this.getNumberOfPieces() == 2) {
                if (this.flag0) {
                    for (e = 0; e < 4 * this.ex; ++e) {
                        trList[4 * this.ex + e] = new GridTransformMatrix(trList[e]);
                        this.data.addGridTransform(trList[4 * this.ex + e].translate(this.halfPeriod.re().times(2.0)));
                    }
                }
                if (this.flag05) {
                    if ((double)this.ex / 2.0 - Math.floor((double)this.ex / 2.0) == 0.0) {
                        for (e = 0; e < 4 * this.ex; ++e) {
                            trList[4 * this.ex + e] = new GridTransformMatrix(trList[e]).rotateZ(180.0);
                            this.data.addGridTransform(trList[4 * this.ex + e].translate(this.halfPeriod.im().times(-2.0)));
                        }
                    } else {
                        for (e = 0; e < 4 * this.ex; e += 2) {
                            trList[4 * this.ex + e] = new GridTransformMatrix(trList[e + 2 * this.ex]).rotateZ(720.0 / (double)this.ex);
                            this.data.addGridTransform(trList[4 * this.ex + e]);
                            trList[4 * this.ex + e + 1] = new GridTransformMatrix(trList[e + 1 + 2 * this.ex]).rotateZ(-720.0 / (double)this.ex);
                            this.data.addGridTransform(trList[4 * this.ex + e + 1]);
                        }
                    }
                }
            }
        }
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        double r = Math.exp(u);
        Complex z = new Complex(r * Math.cos(v), r * Math.sin(v));
        Complex w = new Complex(-z.re + 1.0, -z.im);
        Complex aux = new Complex(z.im, -z.re - 1.0);
        w.assignDivide(aux);
        w = w.mobius1_1(this.mob);
        if (w.r() < 1.0E-6) {
            z.re = -7.0;
        } else {
            z = w.logNearer(I1_C);
        }
        z.re = Math.max(z.re, -7.0);
        z.assignTimes(1.0 / (double)this.ex);
        z = z.exponential();
        return z;
    }

    protected void zeroIndex() {
        double test = 10.0;
        for (int j = 0; j < this.vcount; ++j) {
            Complex z = this.domainGrid(this.umax.getValue(), this.vmin.getValue() + (double)j * this.dv);
            double aux = z.r();
            if (!(aux <= test) || !(Math.abs(z.im) < 1.0E-5)) continue;
            test = aux;
            this.j0 = j;
        }
    }

    @Override
    protected Complex gauss(Complex z) {
        return new Complex(z.integerPower(this.ex - 1));
    }

    @Override
    protected Complex hPrime(Complex z) {
        Complex aux = z.integerPower(this.ex);
        Complex w = aux.minus(4.0 * this.re_e);
        w.assignTimes(aux);
        w.re += 1.0;
        w = this.gauss(z).dividedBy(w);
        w.assignTimes(this.r1);
        return w;
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.AA = Math.sqrt(Math.abs(this.aa.getValue()));
        this.ex = this.exponent.getValue();
        this.rex = 1.0;
        for (int e = 1; e < this.ex + 1; ++e) {
            this.rex *= this.AA;
        }
        this.re_e = this.rex / (this.rex * this.rex + 1.0);
        double ck = 2.0 * this.re_e;
        double sk = Math.sqrt(1.0 - ck * ck);
        this.mob = Math.sqrt((1.0 - sk) / (1.0 - ck) / 2.0);
        this.r1 = 1.3 * Math.sqrt((double)this.ex / 2.0) * Math.exp(2.0 / (double)this.ex * Math.log(1.0 - this.AA * this.AA * this.AA * this.AA));
        this.zeroIndex();
        System.out.println(this.j0);
    }

    @Override
    protected ComplexVector3D getCenter() {
        Complex zj0 = this.domainGrid(this.umax.getValue(), this.vmin.getValue() + (double)this.j0 * this.dv);
        System.out.println(zj0.re);
        Complex around = new Complex(0.005, 0.0);
        ComplexVector3D gC = new ComplexVector3D(this.helperArray[this.ucount - 1][this.j0]);
        gC = gC.plus(this.ComplexVectorIntegrator(zj0, around, this.ex));
        ComplexVector3D aux = this.ComplexVectorIntegrator(around, around.times(I_C), this.ex);
        aux = aux.plus(this.ComplexVectorIntegrator(around.times(I_C), around.times(-1.0), this.ex));
        gC = gC.plus(aux.times(0.5));
        if (!this.inAssociateMorph && !this.wantsToSeeDomain) {
            gC.z = new Complex(this.helperArray[this.ucount - 1][0].z);
        }
        return gC;
    }

    @Override
    public void computeHalfPeriod() {
        this.halfPeriod = new ComplexVector3D(this.helperArray[this.ucount - 1][0]);
        ComplexVector3D aux = new ComplexVector3D(this.helperArray[this.ucount - 1][this.vcount - 1]);
        this.halfPeriod = new ComplexVector3D(this.halfPeriod.y.minus(this.halfPeriod.x), this.halfPeriod.y.plus(this.halfPeriod.x).times(I_C), this.halfPeriod.z.times(2.0));
        aux = new ComplexVector3D(aux.y.minus(aux.x), aux.y.plus(aux.x).times(I_C), aux.z.times(2.0));
        this.halfPeriod.x.re = 0.0;
        this.halfPeriod.y.re = 0.0;
        this.halfPeriod.z.re = (this.halfPeriod.z.re - aux.z.re) / 2.0;
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        int i = (int)Math.floor(0.25 + (u - this.umin.getValue()) / this.du);
        int j = (int)Math.floor(0.25 + (v - this.vmin.getValue()) / this.dv);
        ComplexVector3D auxW = new ComplexVector3D(this.helperArray[i][j].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)i * this.du, this.vmin.getValue() + (double)j * this.dv), this.domainGrid(u, v))));
        ComplexVector3D eW = new ComplexVector3D(auxW.y.minus(auxW.x), auxW.y.plus(auxW.x).times(I_C), auxW.z);
        if (i == this.ucount - 1 && j == this.j0) {
            eW = new ComplexVector3D(ZERO_C, ZERO_C, eW.z);
        }
        if (this.AFP == 0.0) {
            if (this.wantsToSeeDomain) {
                return new Vector3D(eW.z.re, eW.z.im, 0.0);
            }
            return eW.re();
        }
        return eW.re().times(Math.cos(this.AFP)).plus(eW.im().times(Math.sin(this.AFP)));
    }
}

