/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class MonkeySaddle
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 1.0, 1.0, 1.0);
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", 1.0, 1.0, 1.0);
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", 0.35, 0.0, 0.35);

    public MonkeySaddle() {
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(10);
        this.umin.reset(-1.5);
        this.umax.reset(1.5);
        this.vmin.reset(-1.5);
        this.vmax.reset(1.5);
        this.setDefaultViewpoint(new Vector3D(6.64, -13.0, 9.3));
        this.setDefaultWindow(-2.5, 2.5, -2.5, 2.5);
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double x = this.aa.getValue() * v;
        double y = this.bb.getValue() * u;
        double z = this.cc.getValue() * (u * u * u - 3.0 * u * v * v);
        return new Vector3D(x, y, z);
    }
}

