/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.Color;
import vmm.core.Complex;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class DoublyPeriodicJE
extends WeierstrassMinimalSurface {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.DoublyPeriodicJE.aa", 0.0, 0.6, -0.6);
    private int iP;
    private int um;
    private int vm;
    private double PL;
    private double r1;
    private double rB;
    private double rTest;
    private double detour;
    private Complex cP;
    private Complex cP_;
    private Complex qP;
    private ComplexVector3D halfPeriodII;

    public DoublyPeriodicJE() {
        this.addParameter(this.aa);
        this.aa.setMaximumValueForInput(0.9);
        this.aa.setMinimumValueForInput(-0.8);
        this.setDefaultOrientation(0);
        this.setDefaultViewpoint(new Vector3D(-42.0, 19.0, 19.0));
        this.setDefaultWindow(-5.0, 4.0, -4.0, 3.2);
        this.uPatchCount.setValueAndDefault(30);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-4.43);
        this.umax.reset(-this.umin.getValue());
        this.vmin.reset(-1.5707963267948966);
        this.vmax.reset(1.5707963267948966);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.removeParameter(this.umax);
        this.multipleCopyOptions = new int[]{2, 3};
        this.canShowConjugateSurface = true;
        this.wantsToSeeDomain = false;
        this.wantsToSeeGaussImage = false;
        if (this.wantsToSeeGaussImage) {
            this.wantsToSeeDomain = true;
        }
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
    }

    @Override
    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView view = new WeierstrassMinimalSurface.WMSView(this);
        view.setGridSpacing(12);
        float c0 = 0.2f;
        view.getLightSettings().setAmbientLight(new Color(c0, c0, c0));
        view.getLightSettings().setSpecularExponent(55);
        view.getLightSettings().setSpecularRatio(0.5f);
        return view;
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        if (param == this.umin) {
            this.umax.reset(-this.umin.getValue());
        }
    }

    @Override
    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] trList = new GridTransformMatrix[40];
        trList[0] = new GridTransformMatrix();
        if (!this.inAssociateMorph && !this.wantsToSeeDomain && (this.flag0 || this.flag05)) {
            if (this.flag0) {
                trList[1] = new GridTransformMatrix().scale(-1.0, 1.0, 1.0);
                trList[2] = new GridTransformMatrix().scale(1.0, -1.0, -1.0).reverse();
                trList[3] = new GridTransformMatrix().scale(-1.0, -1.0, -1.0).reverse();
            } else if (this.flag05) {
                trList[1] = new GridTransformMatrix().scale(1.0, -1.0, -1.0).reverse();
                trList[2] = new GridTransformMatrix().scale(-1.0, 1.0, 1.0);
                trList[3] = new GridTransformMatrix().scale(-1.0, -1.0, -1.0).reverse();
            }
            this.data.addGridTransform(trList[1]);
            this.data.addGridTransform(trList[2]);
            this.data.addGridTransform(trList[3]);
            if (this.getNumberOfPieces() == 2 || this.getNumberOfPieces() == 3) {
                int e;
                for (e = 2; e < 4; ++e) {
                    if (this.flag0) {
                        trList[e + 2] = new GridTransformMatrix(trList[e]).translate(0.0, 2.0 * this.halfPeriodII.y.re, 0.0);
                    } else if (this.flag05) {
                        trList[e + 2] = new GridTransformMatrix(trList[e]).translate(2.0 * this.halfPeriod.x.im, 0.0, 0.0);
                    }
                    this.data.addGridTransform(trList[e + 2]);
                }
                for (e = 2; e < 4; ++e) {
                    if (this.flag0) {
                        trList[e + 4] = new GridTransformMatrix(trList[e]).translate(0.0, 0.0, 2.0 * this.halfPeriod.z.re);
                    }
                    if (this.flag05) {
                        trList[e + 4] = new GridTransformMatrix(trList[e]).scale(-1.0, -1.0, -1.0).reverse().translate(-2.0 * this.halfPeriod.x.im, 0.0, 0.0);
                    }
                    this.data.addGridTransform(trList[e + 4]);
                }
                if (this.getNumberOfPieces() == 3 && this.flag0) {
                    for (e = 2; e < 4; ++e) {
                        trList[e + 6] = new GridTransformMatrix(trList[e]).translate(0.0, 2.0 * this.halfPeriodII.y.re, 2.0 * this.halfPeriod.z.re);
                        this.data.addGridTransform(trList[e + 6]);
                    }
                    for (e = 0; e < 2; ++e) {
                        trList[e + 10] = new GridTransformMatrix(trList[e]).translate(0.0, 0.0, -2.0 * this.halfPeriod.z.re);
                        this.data.addGridTransform(trList[e + 10]);
                    }
                }
                if (this.getNumberOfPieces() == 3 && this.flag05) {
                    for (e = 2; e < 3; ++e) {
                        trList[e + 6] = new GridTransformMatrix(trList[e]).translate(0.0, 0.0, -2.0 * this.halfPeriodII.z.im);
                        trList[e + 7] = new GridTransformMatrix(trList[e]).translate(0.0, 0.0, -2.0 * this.halfPeriodII.z.im).scale(-1.0, 1.0, 1.0);
                        this.data.addGridTransform(trList[e + 6]);
                        this.data.addGridTransform(trList[e + 7]);
                    }
                    for (e = 0; e < 1; ++e) {
                        trList[e + 10] = new GridTransformMatrix(trList[e]).translate(-2.0 * this.halfPeriod.x.im, 0.0, -2.0 * this.halfPeriodII.z.im);
                        trList[e + 11] = new GridTransformMatrix(trList[e]).translate(-2.0 * this.halfPeriod.x.im, 0.0, -2.0 * this.halfPeriodII.z.im).scale(-1.0, 1.0, 1.0);
                        this.data.addGridTransform(trList[e + 10]);
                        this.data.addGridTransform(trList[e + 11]);
                    }
                }
            }
        }
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        double s;
        double r = Math.exp(u);
        Complex z = new Complex(r * Math.cos(v), r * Math.sin(v));
        Complex aux = new Complex(z.re + 1.0, z.im);
        z.re = 1.0 - z.re;
        z.im = -z.im;
        z.assignDivide(aux);
        if (v < 1.0E-4) {
            s = z.minus(this.cP).r();
            if (s <= this.detour) {
                z.assignTimes(1.0 + s - this.detour);
            } else {
                s = z.minus(this.cP_).r();
                if (s <= this.detour) {
                    z.assignTimes(1.0 + s - this.detour);
                }
            }
        }
        if (v >= this.vmax.getValue() - 1.0E-4) {
            s = z.minus(this.cP.conj()).r();
            if (s <= this.detour) {
                z.assignTimes(1.0 + s - this.detour);
            } else {
                s = z.minus(this.cP_.conj()).r();
                if (s <= this.detour) {
                    z.assignTimes(1.0 + s - this.detour);
                }
            }
        }
        if (this.wantsToSeeGaussImage) {
            z = this.hPrime(z);
        }
        return z;
    }

    protected void p_Index() {
        this.iP = (int)Math.floor((this.rTest - this.umin.getValue()) / (this.umax.getValue() - this.umin.getValue()) * (double)(this.ucount - 1));
    }

    @Override
    protected Complex gauss(Complex z) {
        Complex w = new Complex(1.0 - z.re, -z.im);
        w.assignDivide(new Complex(z.re + 1.0, z.im));
        return w;
    }

    @Override
    protected Complex hPrime(Complex z) {
        Complex w = z.times(z);
        Complex guide = new Complex(z.re, -z.im);
        double denom = w.re * w.re + w.im * w.im;
        w = new Complex(w.re / denom + w.re - this.rB, -w.im * (1.0 / denom - 1.0));
        w = w.squareRootNearer(guide);
        w.assignTimes(z);
        return w.inverse().times(this.r1);
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.PL = 0.7853981633974483 * (1.0 + Math.sin(1.5707963267948966 * this.aa.getValue()));
        this.cP = new Complex(Math.cos(this.PL), Math.sin(this.PL));
        this.cP_ = new Complex(-Math.cos(this.PL), Math.sin(this.PL));
        this.qP = new Complex(this.cP.times(0.9995));
        this.rB = 2.0 * Math.cos(2.0 * this.PL);
        this.rTest = Math.log(Math.sin(this.PL) / (1.0 + Math.cos(this.PL)));
        this.detour = (0.05 * (this.aa.getValue() + 0.7) + 0.005 * (0.9 - this.aa.getValue())) / 2.0;
        this.r1 = 0.5 * (1.0 + this.aa.getValue()) * (1.0 - 0.075 * (double)(this.getNumberOfPieces() - 1));
        if (this.inAssociateMorph) {
            this.r1 *= 1.5;
        }
        this.p_Index();
        this.um = (int)Math.floor((double)this.ucount / 2.0);
        this.vm = (int)Math.floor((double)this.vcount / 2.0);
    }

    @Override
    protected ComplexVector3D getCenter() {
        if (this.inAssociateMorph) {
            return new ComplexVector3D(this.helperArray[this.um][this.vm]);
        }
        if (this.wantsToSeeDomain) {
            return new ComplexVector3D(ZERO_C, ZERO_C, ZERO_C);
        }
        double eps = 0.005;
        Complex cP1 = new Complex(Math.cos(this.PL - eps), Math.sin(this.PL - eps));
        Complex cP2 = new Complex(Math.cos(this.PL) - 0.7 * eps, Math.sin(this.PL) - 0.7 * eps);
        Complex cP3 = new Complex(Math.cos(this.PL + eps), Math.sin(this.PL + eps));
        ComplexVector3D gC = new ComplexVector3D(this.helperArray[this.iP][0]);
        gC.assignPlus(this.ComplexVectorIntegrator(this.domainGrid(this.umin.getValue() + (double)this.iP * this.du, this.vmin.getValue()), cP1, 32));
        ComplexVector3D aux = this.ComplexVectorIntegrator(cP1, cP2, 32);
        aux = aux.plus(this.ComplexVectorIntegrator(cP2, cP3, 32)).times(new Complex(0.5, -0.5));
        return gC.plus(aux);
    }

    @Override
    public void computeHalfPeriod() {
        ComplexVector3D surfMaxMin = this.helperToMinimal(this.helperArray[this.ucount - 1][0]);
        ComplexVector3D surfMinMin = this.helperToMinimal(this.helperArray[0][0]);
        this.halfPeriod = surfMaxMin.minus(surfMinMin);
        this.halfPeriod.x.re = 0.0;
        this.halfPeriod.y.re = 0.0;
        this.halfPeriod.y.im = 0.0;
        this.halfPeriodII = this.helperToMinimal(this.helperArray[this.um][this.vm].times(2.0));
        this.halfPeriodII.x.re = 0.0;
        this.halfPeriodII.z.re = 0.0;
        this.halfPeriodII.y.im = 0.0;
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        int i = (int)Math.floor(0.25 + (u - this.umin.getValue()) / this.du);
        int j = (int)Math.floor(0.25 + (v - this.vmin.getValue()) / this.dv);
        ComplexVector3D auxW = new ComplexVector3D(this.helperArray[i][j].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)i * this.du, this.vmin.getValue() + (double)j * this.dv), this.domainGrid(u, v))));
        ComplexVector3D eW = this.helperToMinimal(auxW);
        if (!this.inAssociateMorph && !this.wantsToSeeDomain) {
            if (i == this.iP && j == 0) {
                eW = new ComplexVector3D(ComplexVector3D.ORIGIN);
            } else if (i == this.ucount - 1 - this.iP && j == 0) {
                eW = new ComplexVector3D(this.halfPeriod);
            } else if (i == this.iP && j == this.vcount - 1) {
                eW = new ComplexVector3D(this.halfPeriodII);
            } else if (i == this.ucount - 1 - this.iP && j == this.vcount - 1) {
                if (this.flag0) {
                    eW = new ComplexVector3D(this.halfPeriod.plus(this.halfPeriodII));
                } else if (this.flag05) {
                    eW = new ComplexVector3D(this.halfPeriod.times(-1.0).plus(this.halfPeriodII));
                }
            }
            if (this.flag0) {
                if ((j == 0 || j == this.vcount - 1) && i > this.iP && i < this.ucount - 1 - this.iP) {
                    eW.x.assign(ZERO_C);
                }
                if (j == 0 && i < this.iP) {
                    eW.assign(eW.x, ZERO_C, ZERO_C);
                }
                if (j == 0 && i > this.ucount - 1 - this.iP) {
                    eW.assign(eW.x, ZERO_C, this.halfPeriod.z);
                }
                if (j == this.vcount - 1 && i < this.iP) {
                    eW.assign(eW.x, this.halfPeriodII.y, ZERO_C);
                }
                if (j == this.vcount - 1 && i > this.ucount - 1 - this.iP) {
                    eW.assign(eW.x, this.halfPeriodII.y, this.halfPeriod.z);
                }
            }
            if (this.flag05) {
                if (j == 0 && i > this.iP && i < this.ucount - 1 - this.iP) {
                    eW.assign(eW.x, ZERO_C, ZERO_C);
                }
                if (j == this.vcount - 1 && i > this.iP && i < this.ucount - 1 - this.iP) {
                    eW.assign(eW.x, ZERO_C, this.halfPeriodII.z);
                }
            }
        }
        if (this.wantsToSeeDomain) {
            return new Vector3D(eW.z.re, eW.z.im, 0.0);
        }
        if (this.AFP == 0.0) {
            return eW.re();
        }
        return eW.re().times(Math.cos(this.AFP)).plus(eW.im().times(Math.sin(this.AFP)));
    }
}

