/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.Color;
import vmm.core.Complex;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class DoublyPeriodicJD
extends WeierstrassMinimalSurface {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.DoublyPeriodicJD.aa", 0.0, 0.6, -0.6);
    private int jP;
    private int um;
    private int vm;
    private double PL;
    private double r1;
    private double rB;
    private Complex cP;
    private Complex qP;
    private ComplexVector3D halfPeriodII;

    public DoublyPeriodicJD() {
        this.addParameter(this.aa);
        this.aa.setMaximumValueForInput(0.9);
        this.aa.setMinimumValueForInput(-0.84);
        this.setDefaultOrientation(0);
        this.setDefaultViewUp(new Vector3D(0.35, 0.05, 0.93));
        this.setDefaultViewpoint(new Vector3D(-46.0, -8.0, 18.0));
        this.setDefaultWindow(-4.5, 2.7, -3.9, 2.2);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(12);
        this.umin.reset(-4.5);
        this.umax.reset(0.0);
        this.vmin.reset(-1.5707963267948966);
        this.vmax.reset(1.5707963267948966);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.removeParameter(this.umax);
        this.wantsToSeeDomain = false;
        this.wantsToSeeGaussImage = false;
        if (this.wantsToSeeGaussImage) {
            this.wantsToSeeDomain = true;
        }
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.multipleCopyOptions = new int[]{2};
        this.canShowConjugateSurface = true;
    }

    @Override
    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView view = new WeierstrassMinimalSurface.WMSView(this);
        float c0 = 0.3f;
        view.getLightSettings().setAmbientLight(new Color(c0, c0, c0));
        view.getLightSettings().setSpecularExponent(55);
        view.getLightSettings().setSpecularRatio(0.5f);
        return view;
    }

    @Override
    protected void createData() {
        super.createData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] trList = new GridTransformMatrix[40];
        trList[0] = new GridTransformMatrix();
        GridTransformMatrix a = new GridTransformMatrix();
        if (!this.inAssociateMorph && !this.wantsToSeeDomain) {
            if (this.flag0) {
                trList[1] = new GridTransformMatrix().scale(1.0, 1.0, -1.0);
                trList[2] = new GridTransformMatrix().scale(-1.0, -1.0, 1.0).reverse();
                trList[3] = new GridTransformMatrix().scale(-1.0, -1.0, -1.0).reverse();
            } else if (this.flag05) {
                trList[1] = new GridTransformMatrix().scale(-1.0, -1.0, 1.0).reverse();
                trList[2] = new GridTransformMatrix().scale(1.0, 1.0, -1.0);
                trList[3] = new GridTransformMatrix().scale(-1.0, -1.0, -1.0).reverse();
            }
            this.data.addGridTransform(trList[1]);
            this.data.addGridTransform(trList[2]);
            this.data.addGridTransform(trList[3]);
            Vector3D trans = new Vector3D();
            if (this.flag0) {
                a = new GridTransformMatrix().scale(1.0, -1.0, -1.0).reverse();
                trans.z = this.halfPeriodII.z.re;
            } else if (this.flag05) {
                a = new GridTransformMatrix().scale(-1.0, 1.0, 1.0);
                trans.x = this.halfPeriodII.x.im;
            }
            for (int e = 0; e < 4; ++e) {
                trList[e + 4] = new GridTransformMatrix(trList[e]).leftMultiplyBy(a).translate(trans);
                this.data.addGridTransform(trList[e + 4]);
            }
            if (this.getNumberOfPieces() == 2) {
                GridTransformMatrix b = new GridTransformMatrix();
                Vector3D transs = new Vector3D();
                if (this.flag0) {
                    b = new GridTransformMatrix().scale(-1.0, -1.0, 1.0).reverse();
                    transs.y = 2.0 * this.halfPeriod.y.re;
                } else if (this.flag05) {
                    b = new GridTransformMatrix().scale(-1.0, 1.0, 1.0);
                    transs.x = 3.0 * this.halfPeriodII.x.im;
                }
                for (int e = 0; e < 8; ++e) {
                    trList[e + 8] = new GridTransformMatrix(trList[e]).leftMultiplyBy(b).translate(transs);
                    this.data.addGridTransform(trList[e + 8]);
                }
            }
        }
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        double r = Math.exp(u);
        if (u > this.umax.getValue() - 0.001) {
            r -= Math.max(Math.max(0.0, 0.04 - Math.abs(v - this.PL)), 0.04 - Math.abs(v + this.PL));
        }
        Complex z = new Complex(r * Math.cos(v), r * Math.sin(v));
        if (this.wantsToSeeGaussImage) {
            z = this.hPrime(z);
        }
        return z;
    }

    protected void p_Index() {
        this.jP = (int)Math.floor((this.PL - this.vmin.getValue()) / (this.vmax.getValue() - this.vmin.getValue()) * (double)(this.vcount - 1));
    }

    @Override
    protected Complex gauss(Complex z) {
        return new Complex(z);
    }

    @Override
    protected Complex hPrime(Complex z) {
        Complex w = z.times(z);
        Complex guide = new Complex(z.re, -z.im);
        double denom = w.re * w.re + w.im * w.im;
        w = new Complex(w.re / denom + w.re - this.rB, -w.im * (1.0 / denom - 1.0));
        w = w.squareRootNearer(guide);
        w.assignTimes(z);
        return w.inverse().times(this.r1);
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.PL = 0.7853981633974483 * (1.0 + Math.sin(1.5707963267948966 * this.aa.getValue()));
        this.cP = new Complex(Math.cos(this.PL), Math.sin(this.PL));
        this.qP = new Complex(this.cP.times(0.99995));
        this.rB = 2.0 * Math.cos(2.0 * this.PL);
        this.r1 = 0.5;
        if (this.inAssociateMorph) {
            this.r1 = 1.0;
        }
        this.p_Index();
        this.um = (int)Math.floor(this.ucount - 1);
        this.vm = (int)Math.floor(this.vcount / 2);
    }

    @Override
    protected ComplexVector3D getCenter() {
        if (this.inAssociateMorph) {
            return new ComplexVector3D(this.helperArray[this.um][this.vm]);
        }
        if (this.wantsToSeeDomain) {
            return new ComplexVector3D(ZERO_C, ZERO_C, ZERO_C);
        }
        ComplexVector3D gC = new ComplexVector3D(this.helperArray[this.ucount - 1][this.jP]);
        gC = gC.plus(this.ComplexVectorIntegrator(this.domainGrid(this.umax.getValue(), this.vmin.getValue() + (double)this.jP * this.dv), this.qP, 32));
        return gC;
    }

    @Override
    public void computeHalfPeriod() {
        this.halfPeriod = new ComplexVector3D(this.helperArray[this.um][this.vm].times(2.0));
        this.halfPeriod.assign(ZERO_C, this.halfPeriod.y.plus(this.halfPeriod.x).times(I_C), this.halfPeriod.z);
        this.halfPeriodII = new ComplexVector3D(this.helperArray[this.ucount - 1][this.vcount - 1].times(2.0));
        ComplexVector3D aux = new ComplexVector3D(this.helperArray[this.ucount - 1][0]);
        this.halfPeriodII.assign(aux.y.plus(aux.x), ZERO_C, this.halfPeriodII.z);
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        ComplexVector3D eW;
        int i = (int)Math.floor(0.25 + (u - this.umin.getValue()) / this.du);
        int j = (int)Math.floor(0.25 + (v - this.vmin.getValue()) / this.dv);
        if (!this.inAssociateMorph && !this.wantsToSeeDomain && i == this.ucount - 1 && j == this.jP) {
            eW = new ComplexVector3D(ComplexVector3D.ORIGIN);
        } else if (!this.inAssociateMorph && !this.wantsToSeeDomain && i == this.ucount - 1 && j == this.vcount - 1 - this.jP) {
            eW = new ComplexVector3D(this.halfPeriod);
        } else {
            ComplexVector3D auxW = new ComplexVector3D(this.helperArray[i][j].plus(this.ComplexVectorOneStepIntegrator(this.domainGrid(this.umin.getValue() + (double)i * this.du, this.vmin.getValue() + (double)j * this.dv), this.domainGrid(u, v))));
            eW = new ComplexVector3D(auxW.y.minus(auxW.x), auxW.y.plus(auxW.x).times(I_C), auxW.z);
            if (!this.inAssociateMorph && !this.wantsToSeeDomain) {
                if (this.flag0) {
                    if (i == this.ucount - 1 && j <= this.jP && j >= this.vcount - 1 - this.jP) {
                        eW.z.assign(ZERO_C);
                    }
                    if (i == this.ucount - 1 && j > this.jP) {
                        eW.assign(ZERO_C, ZERO_C, eW.z);
                    }
                    if (i == this.ucount - 1 && j < this.vcount - 1 - this.jP) {
                        eW.assign(this.halfPeriod.x, this.halfPeriod.y, eW.z);
                    }
                }
                if (this.flag05) {
                    if (i == this.ucount - 1 && j > this.jP) {
                        eW.z.assign(ZERO_C);
                    }
                    if (i == this.ucount - 1 && j < this.vcount - 1 - this.jP) {
                        eW.z.assign(this.halfPeriod.z);
                    }
                }
            }
        }
        if (this.wantsToSeeDomain) {
            return new Vector3D(eW.z.re, eW.z.im, 0.0);
        }
        if (this.AFP == 0.0) {
            return eW.re();
        }
        return eW.re().times(Math.cos(this.AFP)).plus(eW.im().times(Math.sin(this.AFP)));
    }
}

