/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Catenoid_Helicoid
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "0", "0", "pi/2");
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", 0.5, 0.5, 0.5);

    public Catenoid_Helicoid() {
        this.uPatchCount.setValueAndDefault(16);
        this.vPatchCount.setValueAndDefault(10);
        this.umin.reset("-pi");
        this.umax.reset("pi");
        this.vmin.reset(-1.6);
        this.vmax.reset(1.6);
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.5, 2.5, -2.5, 2.5);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
    }

    private static double sinh(double t) {
        return 0.5 * (Math.exp(t) - Math.exp(-t));
    }

    private static double cosh(double t) {
        return 0.5 * (Math.exp(t) + Math.exp(-t));
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = this.aa.getValue();
        double BB = this.bb.getValue();
        double x = BB * (Math.cos(AA) * Catenoid_Helicoid.sinh(v) * Math.sin(u) + Math.sin(AA) * Catenoid_Helicoid.cosh(v) * Math.cos(u));
        double y = BB * (-Math.cos(AA) * Catenoid_Helicoid.sinh(v) * Math.cos(u) + Math.sin(AA) * Catenoid_Helicoid.cosh(v) * Math.sin(u));
        double z = BB * (Math.cos(AA) * u + Math.sin(AA) * v);
        return new Vector3D(x, y, z);
    }
}

