/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.implicit;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.implicit.SurfaceImplicit;

public class Torus
extends SurfaceImplicit {
    private RealParamAnimateable a = new RealParamAnimateable("vmm.surface.implicit.Torus.a", 1.0, 1.0, 1.0);
    private RealParamAnimateable b = new RealParamAnimateable("vmm.surface.implicit.Torus.b", 2.0, 2.0, 3.0);

    public static double sqr(double x) {
        return x * x;
    }

    @Override
    public double heightFunction(double x, double y, double z) {
        double bb = this.b.getValue();
        double xsqr = Torus.sqr(x);
        double ysqr = Torus.sqr(y);
        double zsqr = Torus.sqr(z);
        double height = Torus.sqr(Math.sqrt(xsqr + ysqr) - bb) + zsqr;
        return height;
    }

    public Torus() {
        this.addParameter(this.b);
        this.addParameter(this.a);
        this.setDefaultWindow(-3.0, 3.0, -3.0, 3.0);
        this.setDefaultViewpoint(new Vector3D(-20.0, 23.0, 24.0));
        this.searchRadius.reset(3.0);
        this.randomLineCount.reset(60000);
        this.pointCloudCount.reset(12000);
        this.level.reset(1.0, 1.0, 0.05);
        this.setFramesForMorphing(12);
    }
}

