/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.implicit;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.implicit.SurfaceImplicit;

public class Join2Tori
extends SurfaceImplicit {
    private RealParamAnimateable a = new RealParamAnimateable("vmm.surface.implicit.Join2Tori.a", 1.5, 1.5, 1.5);
    private RealParamAnimateable b = new RealParamAnimateable("vmm.surface.implicit.Join2Tori.b", 0.5, 0.5, 0.5);
    private RealParamAnimateable c = new RealParamAnimateable("vmm.surface.implicit.Join2Tori.c", 2.2, 2.2, 2.2);

    public static double sqr(double x) {
        return x * x;
    }

    @Override
    public double heightFunction(double x, double y, double z) {
        double cc = this.c.getValue();
        double bb = this.b.getValue();
        double aa = this.a.getValue();
        double aasqr = Join2Tori.sqr(aa);
        double bbsqr = Join2Tori.sqr(bb);
        double aux = 4.0 * bbsqr * aasqr;
        double xlsqr = Join2Tori.sqr(x - cc);
        double xrsqr = Join2Tori.sqr(x + cc);
        double ysqr = Join2Tori.sqr(y);
        double zsqr = Join2Tori.sqr(z);
        double partA = Join2Tori.sqr(xlsqr + ysqr + zsqr - bbsqr - aasqr) + 4.0 * aasqr * zsqr - aux;
        double partB = Join2Tori.sqr(xrsqr + ysqr + zsqr - bbsqr - aasqr) + 4.0 * aasqr * zsqr - aux;
        double height = partA * partB / Join2Tori.sqr(1.0 + xlsqr + xrsqr + ysqr + zsqr / 2.0);
        return height;
    }

    public Join2Tori() {
        this.addParameter(this.c);
        this.addParameter(this.b);
        this.addParameter(this.a);
        this.setDefaultWindow(-3.75, 3.75, -3.75, 3.75);
        this.setDefaultViewpoint(new Vector3D(2.0, 16.0, 10.0));
        this.searchRadius.reset(5.0);
        this.randomLineCount.reset(60000);
        this.pointCloudCount.reset(12000);
        this.level.reset(0.5, 1.0, 1.5);
        this.setFramesForMorphing(11);
    }
}

