/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SphericalCurve;

public class SphericalEllipse
extends SphericalCurve {
    RealParamAnimateable aa = new RealParamAnimateable("vmm.spacecurve.parametric.SphericalEllipse.aa", 0.6, 0.6, 0.6);
    RealParamAnimateable ee = new RealParamAnimateable("vmm.spacecurve.parametric.SphericalEllipse.ee", 0.9, 0.4, 1.15);

    public SphericalEllipse() {
        this.setDefaultViewpoint(new Vector3D(10.0, 0.0, 30.0));
        this.setDefaultWindow(-1.1, 1.1, -1.1, 1.1);
        this.tResolution.setValueAndDefault(200);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("2 * pi");
        this.addParameter(this.ee);
        this.addParameter(this.aa);
        this.tubeSize.setValueAndDefault(0.1);
    }

    @Override
    protected Vector3D value(double t) {
        double a = this.aa.getValue();
        double e = this.ee.getValue();
        Vector3D N = new Vector3D(0.0, 0.0, 1.0);
        Vector3D F = new Vector3D(Math.sin(e), 0.0, Math.cos(e));
        Vector3D P = this.geographicCoordinates(2.0 * a, t);
        Vector3D SecantFtoP = P.minus(F);
        SecantFtoP.normalize();
        Vector3D Aux = F.minus(P);
        double coeff1 = Aux.dot(P.minus(N));
        double coeff2 = Aux.dot(P);
        double c = coeff2 / coeff1;
        Vector3D E = N.linComb(c, 1.0 - c, P);
        if (2.0 * a > Math.PI) {
            E.negate();
        }
        E.normalize();
        return new Vector3D(E);
    }
}

