/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SpaceCurveParametric;

public class Helix
extends SpaceCurveParametric {
    private RealParamAnimateable radiusX;
    private RealParamAnimateable radiusZ;
    private RealParamAnimateable risePerTurn;

    public Helix() {
        this.tResolution.setValueAndDefault(150);
        this.tmin.setValueAndDefaultFromString("-3 * pi");
        this.tmax.setValueAndDefaultFromString("3 * pi");
        this.radiusX = new RealParamAnimateable("vmm.spacecurve.parametric.Helix.radiusX", 1.5, 1.5, 1.5);
        this.radiusZ = new RealParamAnimateable("vmm.spacecurve.parametric.Helix.radiusZ", 1.5, 1.5, 1.5);
        this.risePerTurn = new RealParamAnimateable("vmm.spacecurve.parametric.Helix.risePerTurn", 2.5, 1.0, 3.0);
        this.addParameter(this.risePerTurn);
        this.addParameter(this.radiusZ);
        this.addParameter(this.radiusX);
        this.setDefaultWindow(-5.0, 5.0, -3.0, 3.0);
        this.setDefaultViewpoint(new Vector3D(20.0, 5.0, 2.0));
        this.tubeSize.setValueAndDefault(0.5);
    }

    @Override
    protected Vector3D value(double t) {
        double x = this.radiusX.getValue() * Math.cos(t);
        double y = t * this.risePerTurn.getValue() / (Math.PI * 2);
        double z = this.radiusZ.getValue() * Math.sin(t);
        return new Vector3D(x, y, z);
    }

    @Override
    protected Vector3D deriv1(double t) {
        double x = -this.radiusX.getValue() * Math.sin(t);
        double y = this.risePerTurn.getValue() / (Math.PI * 2);
        double z = this.radiusZ.getValue() * Math.cos(t);
        return new Vector3D(x, y, z);
    }

    @Override
    protected Vector3D deriv2(double t) {
        double x = -this.radiusX.getValue() * Math.cos(t);
        double y = 0.0;
        double z = -this.radiusZ.getValue() * Math.sin(t);
        return new Vector3D(x, y, z);
    }
}

