/*
 * Decompiled with CFR 0.152.
 */
package vmm.pseudospherical;

import vmm.core.Complex;
import vmm.core3D.Vector3D;
import vmm.pseudospherical.Breather;
import vmm.pseudospherical.ComplexMatrix2D;

public class BreatherPlusSoliton
extends Breather {
    public BreatherPlusSoliton() {
        this.alpha.setValue(new Complex(0.8, 0.6));
        this.setDefaultWindow(-2.49198, 2.00802, -0.240364, 3.25964);
        this.setDefaultViewpoint(new Vector3D(-2.45611, -7.56097, 1.05439));
        this.setDefaultViewUp(new Vector3D(-0.312026, 0.22991, 0.921836));
    }

    @Override
    public synchronized Vector3D surfacePoint(double x, double t) {
        ComplexMatrix2D ret = this.firstSoliton(x, t);
        ret = this.compBreather(x, t, true);
        double aa = ret.entries[1][1].im;
        double bb = ret.entries[1][2].re;
        double cc = ret.entries[1][2].im;
        if (Double.isNaN(aa) || Double.isNaN(aa) || Double.isNaN(aa)) {
            cc = 0.0;
            bb = 0.0;
            aa = 0.0;
        }
        return new Vector3D(aa, bb, cc);
    }
}

