/*
 * Decompiled with CFR 0.152.
 */
package vmm.polyhedron;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.core.I18n;
import vmm.core.Parameter;
import vmm.core.RealParamAnimateable;
import vmm.core.TimerAnimation;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;
import vmm.polyhedron.IFS;

public abstract class RegularPolyhedron
extends IFS {
    protected Vector3D[] polyhedronVertices;
    protected int[][] polyhedronFaces;
    private int[][] edgeList;
    private Vector3D[] mangledPolyhedronVertices;
    private int[][] mangledPolyhedronFaces;
    private boolean mangledPolyhedronIsStellated = false;
    @VMMSave
    private boolean stellationWanted = false;
    private double currentTruncation = -1.0;
    protected double stellationScale = 0.5;
    protected double stellationHeight = 1.0;
    private double stellationDegree = 1.0;
    private double stellationDegreeUsed = -1.0;
    protected RealParamAnimateable truncation;
    protected ActionRadioGroup truncationSelect = new ActionRadioGroup(new String[]{I18n.tr("vmm.polyhedron.RegularPolyhedron.NoTruncation"), I18n.tr("vmm.polyhedron.RegularPolyhedron.StandardTruncation"), I18n.tr("vmm.polyhedron.RegularPolyhedron.MidpointTruncation"), I18n.tr("vmm.polyhedron.RegularPolyhedron.Stellated")}, 0){

        @Override
        public void optionSelected(int selectedIndex) {
            if (selectedIndex == 0) {
                RegularPolyhedron.this.truncation.setValue(1.0);
            } else if (selectedIndex == 1) {
                RegularPolyhedron.this.truncation.setValueFromString("2/3");
            } else if (selectedIndex == 2) {
                RegularPolyhedron.this.truncation.setValueFromString("1/2");
            }
            RegularPolyhedron.this.setStellationWanted(selectedIndex == 3);
        }
    };

    protected RegularPolyhedron() {
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        this.truncation = new RealParamAnimateable("vmm.polyhedron.RegularPolyhedron.truncation", "1", "1", "1/2");
        this.truncation.setMinimumValueForInput(0.5);
        this.truncation.setMaximumValueForInput(1.0);
        this.addParameter(this.truncation);
    }

    public boolean getStellationWanted() {
        return this.stellationWanted;
    }

    public void setStellationWanted(boolean stellationWanted) {
        if (this.stellationWanted == stellationWanted) {
            return;
        }
        this.stellationWanted = stellationWanted;
        if (stellationWanted) {
            this.truncationSelect.setSelectedIndex(3);
        } else {
            double val = this.truncation.getValue();
            if (val > 0.995) {
                this.truncationSelect.setSelectedIndex(0);
            } else if (Math.abs(val - 0.6666666666666666) < 0.005) {
                this.truncationSelect.setSelectedIndex(1);
            } else if (val < 0.505) {
                this.truncationSelect.setSelectedIndex(2);
            } else {
                this.truncationSelect.setSelectedIndex(-1);
            }
        }
        this.forceRedraw();
    }

    @Override
    protected void computeDrawData3D(View3D view, boolean exhibitNeedsRedraw, Transform3D previousTransform3D, Transform3D newTransform3D) {
        double trunc = 1.0 - this.truncation.getValue();
        if (trunc <= 0.005) {
            trunc = 0.0;
        } else if (trunc >= 0.495) {
            trunc = 0.5;
        }
        if (this.stellationWanted) {
            if (!this.mangledPolyhedronIsStellated || this.stellationDegree != this.stellationDegreeUsed) {
                this.makeStellatedPolyhedron();
                this.mangledPolyhedronIsStellated = true;
                this.setIFSData(this.mangledPolyhedronVertices, this.mangledPolyhedronFaces);
            }
        } else if (this.mangledPolyhedronIsStellated || trunc != this.currentTruncation) {
            if (trunc == 0.0) {
                this.mangledPolyhedronFaces = null;
                this.mangledPolyhedronVertices = null;
                this.setIFSData(this.polyhedronVertices, this.polyhedronFaces);
            } else {
                if (this.edgeList == null) {
                    this.makeEdgeList();
                }
                this.makeTruncatedPolyhedron(trunc);
                this.setIFSData(this.mangledPolyhedronVertices, this.mangledPolyhedronFaces);
            }
            this.currentTruncation = trunc;
            this.mangledPolyhedronIsStellated = false;
        }
        super.computeDrawData3D(view, exhibitNeedsRedraw, previousTransform3D, newTransform3D);
    }

    @Override
    public ActionList getActionsForView(View view) {
        ActionList actions = super.getActionsForView(view);
        actions.add(null);
        actions.add(this.truncationSelect);
        return actions;
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        if (param == this.truncation) {
            this.stellationWanted = false;
            double val = this.truncation.getValue();
            if (val > 0.995) {
                this.truncationSelect.setSelectedIndex(0);
            } else if (Math.abs(val - 0.6666666666666666) < 0.005) {
                this.truncationSelect.setSelectedIndex(1);
            } else if (val < 0.505) {
                this.truncationSelect.setSelectedIndex(2);
            } else {
                this.truncationSelect.setSelectedIndex(-1);
            }
        }
    }

    @Override
    public ActionList getAdditionalAnimationsForView(final View view) {
        ActionList actions = super.getAdditionalAnimationsForView(view);
        actions.add(new AbstractActionVMM(I18n.tr("vmm.polyhedron.RegularPolyhedron.StellationMorph")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimerAnimation animation = new TimerAnimation(){

                    @Override
                    protected void animationStarting() {
                        RegularPolyhedron.this.stellationDegree = 0.0;
                        RegularPolyhedron.this.truncation.setValue(1.0);
                        RegularPolyhedron.this.setStellationWanted(true);
                        RegularPolyhedron.this.forceRedraw();
                    }

                    @Override
                    protected void animationEnding() {
                        RegularPolyhedron.this.stellationDegree = 1.0;
                        RegularPolyhedron.this.forceRedraw();
                    }

                    @Override
                    protected void drawFrame() {
                        RegularPolyhedron.this.stellationDegree = (double)this.getFrameNumber() / (double)this.getFrames();
                        RegularPolyhedron.this.forceRedraw();
                    }
                };
                animation.setLooping(2);
                animation.setFrames(RegularPolyhedron.this.getFramesForMorphing());
                view.getDisplay().installAnimation(animation);
            }
        });
        return actions;
    }

    private void makeEdgeList() {
        this.edgeList = new int[this.polyhedronVertices.length][];
        for (int v = 0; v < this.polyhedronVertices.length; ++v) {
            ArrayList<Integer> endpoints = new ArrayList<Integer>();
            for (int[] face : this.polyhedronFaces) {
                for (int i = 0; i < face.length; ++i) {
                    int prevv;
                    if (face[i] != v) continue;
                    int nextv = i == face.length - 1 ? face[0] : face[i + 1];
                    int n = prevv = i == 0 ? face[face.length - 1] : face[i - 1];
                    if (!endpoints.contains(nextv)) {
                        endpoints.add(nextv);
                    }
                    if (endpoints.contains(prevv)) continue;
                    endpoints.add(prevv);
                }
            }
            int[] e = new int[endpoints.size()];
            e[0] = (Integer)endpoints.remove(0);
            Vector3D top = this.polyhedronVertices[v];
            block3: for (int i = 1; i < e.length; ++i) {
                Vector3D v1 = this.polyhedronVertices[e[i - 1]];
                for (int j = 0; j < endpoints.size(); ++j) {
                    Vector3D v2 = this.polyhedronVertices[(Integer)endpoints.get(j)];
                    Vector3D n = top.minus(v1).cross(v2.minus(v1));
                    boolean ok = true;
                    for (int k = 0; k < endpoints.size(); ++k) {
                        if (k == j || !(n.dot(this.polyhedronVertices[(Integer)endpoints.get(k)].minus(v1)) > 0.0)) continue;
                        ok = false;
                        break;
                    }
                    if (!ok) continue;
                    e[i] = (Integer)endpoints.remove(j);
                    continue block3;
                }
            }
            this.edgeList[v] = e;
        }
    }

    private void makeTruncatedPolyhedron(double truncation) {
        int i;
        int origEdges = 0;
        for (int[] vi : this.polyhedronFaces) {
            origEdges += vi.length;
        }
        int vertexCount = origEdges;
        this.mangledPolyhedronVertices = new Vector3D[vertexCount];
        int faceCount = this.polyhedronFaces.length + this.polyhedronVertices.length;
        this.mangledPolyhedronFaces = new int[faceCount][];
        int face = 0;
        int vertex = 0;
        int[] vertexOffsets = new int[this.polyhedronVertices.length];
        for (i = 0; i < this.polyhedronVertices.length; ++i) {
            vertexOffsets[i] = vertex;
            int[] faceData = new int[this.edgeList[i].length];
            for (int j = 0; j < this.edgeList[i].length; ++j) {
                this.mangledPolyhedronVertices[vertex] = this.polyhedronVertices[i].plus(this.polyhedronVertices[this.edgeList[i][j]].minus(this.polyhedronVertices[i]).times(truncation));
                faceData[j] = vertex++;
            }
            this.mangledPolyhedronFaces[face++] = faceData;
        }
        for (i = 0; i < this.polyhedronFaces.length; ++i) {
            int faceSize = this.polyhedronFaces[i].length;
            if (truncation < 0.5) {
                faceSize *= 2;
            }
            int[] faceData = new int[faceSize];
            int v = 0;
            for (int j = 0; j < this.polyhedronFaces[i].length; ++j) {
                int offset2;
                int v1 = this.polyhedronFaces[i][j];
                int v2 = this.polyhedronFaces[i][j == this.polyhedronFaces[i].length - 1 ? 0 : j + 1];
                int offset1 = vertexOffsets[v1];
                for (offset2 = 0; offset2 < this.edgeList[v1].length && this.edgeList[v1][offset2] != v2; ++offset2) {
                }
                assert (offset2 < this.edgeList[v1].length);
                faceData[v++] = offset1 + offset2;
                if (!(truncation < 0.5)) continue;
                offset1 = vertexOffsets[v2];
                for (offset2 = 0; offset2 < this.edgeList[v2].length && this.edgeList[v2][offset2] != v1; ++offset2) {
                }
                assert (offset2 < this.edgeList[v2].length);
                faceData[v++] = offset1 + offset2;
            }
            this.mangledPolyhedronFaces[face++] = faceData;
        }
    }

    private void makeStellatedPolyhedron() {
        int vertexCount = this.polyhedronVertices.length + this.polyhedronFaces.length;
        this.mangledPolyhedronVertices = new Vector3D[vertexCount];
        int faceCount = 0;
        for (int[] vi : this.polyhedronFaces) {
            faceCount += vi.length;
        }
        this.mangledPolyhedronFaces = new int[faceCount][];
        for (int i = 0; i < this.polyhedronVertices.length; ++i) {
            this.mangledPolyhedronVertices[i] = this.polyhedronVertices[i].times(this.stellationScale);
        }
        double stellationHeightScaled = this.stellationHeight * this.stellationScale;
        int vertex = this.polyhedronVertices.length;
        int face = 0;
        for (int[] faceVertexList : this.polyhedronFaces) {
            Vector3D pyramidTop;
            Vector3D edge1 = this.mangledPolyhedronVertices[faceVertexList[1]].minus(this.mangledPolyhedronVertices[faceVertexList[0]]);
            Vector3D edge2 = this.mangledPolyhedronVertices[faceVertexList[2]].minus(this.mangledPolyhedronVertices[faceVertexList[1]]);
            Vector3D axisDirection = edge2.cross(edge1).normalized();
            Vector3D faceCenter = new Vector3D(0.0, 0.0, 0.0);
            for (int i : faceVertexList) {
                faceCenter.assignPlus(this.mangledPolyhedronVertices[i]);
            }
            faceCenter = faceCenter.times(1.0 / (double)faceVertexList.length);
            this.mangledPolyhedronVertices[vertex] = pyramidTop = faceCenter.plus(axisDirection.times(stellationHeightScaled * this.stellationDegree));
            for (int i = 1; i < faceVertexList.length; ++i) {
                this.mangledPolyhedronFaces[face++] = new int[]{faceVertexList[i - 1], faceVertexList[i], vertex};
            }
            this.mangledPolyhedronFaces[face++] = new int[]{faceVertexList[faceVertexList.length - 1], faceVertexList[0], vertex++};
        }
        this.stellationDegreeUsed = this.stellationDegree;
        assert (vertex == this.mangledPolyhedronVertices.length);
        assert (face == this.mangledPolyhedronFaces.length);
    }
}

